/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.javers.common.collections.Primitives;
import org.javers.common.collections.WellKnownValueTypes;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.diff.ListCompareAlgorithm;
import org.javers.core.metamodel.type.ArrayType;
import org.javers.core.metamodel.type.CollectionType;
import org.javers.core.metamodel.type.DuckType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ListAsSetType;
import org.javers.core.metamodel.type.ListType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.MapType;
import org.javers.core.metamodel.type.OptionalType;
import org.javers.core.metamodel.type.PrimitiveType;
import org.javers.core.metamodel.type.SetType;
import org.javers.core.metamodel.type.ValueType;

class TypeMapperEngine {
    private final Map<String, JaversType> mappedTypes = new ConcurrentHashMap<String, JaversType>();
    private final Map<DuckType, Class> mappedTypeNames = new ConcurrentHashMap<DuckType, Class>();

    TypeMapperEngine() {
    }

    private void putIfAbsent(Type javaType, JaversType jType) {
        Validate.argumentsAreNotNull(javaType, jType);
        if (this.contains(javaType)) {
            return;
        }
        this.addFullMapping(javaType, jType);
    }

    private void putWithOverwrite(Type javaType, JaversType jType) {
        Validate.argumentsAreNotNull(javaType, jType);
        this.addFullMapping(javaType, jType);
    }

    void registerCoreTypes(ListCompareAlgorithm listCompareAlgorithm) {
        for (Class<?> primitiveOrBox : Primitives.getPrimitiveAndBoxTypes()) {
            this.registerCoreType(new PrimitiveType(primitiveOrBox));
        }
        this.registerCoreType(new PrimitiveType((Type)((Object)Enum.class)));
        this.registerCoreType(new ArrayType((Type)((Object)Object[].class)));
        for (Class<?> valueType : WellKnownValueTypes.getValueTypes()) {
            this.registerCoreType(new ValueType(valueType));
        }
        this.registerCoreType(new CollectionType((Type)((Object)Collection.class)));
        this.registerCoreType(new SetType((Type)((Object)Set.class)));
        if (listCompareAlgorithm == ListCompareAlgorithm.AS_SET) {
            this.registerCoreType(new ListAsSetType((Type)((Object)List.class)));
        } else {
            this.registerCoreType(new ListType((Type)((Object)List.class)));
        }
        this.registerCoreType(new OptionalType());
        this.registerCoreType(new MapType((Type)((Object)Map.class)));
    }

    void registerExplicitType(JaversType javersType) {
        this.putWithOverwrite(javersType.getBaseJavaType(), javersType);
    }

    private void registerCoreType(JaversType jType) {
        this.putIfAbsent(jType.getBaseJavaType(), jType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JaversType computeIfAbsent(Type javaType, Function<Type, JaversType> computeFunction) {
        JaversType javersType = this.get(javaType);
        if (javersType != null) {
            return javersType;
        }
        Type type = javaType;
        synchronized (type) {
            JaversType mappedType = this.get(javaType);
            if (mappedType != null) {
                return mappedType;
            }
            JaversType newType = computeFunction.apply(javaType);
            this.addFullMapping(javaType, newType);
            return newType;
        }
    }

    private void addFullMapping(Type javaType, JaversType newType) {
        Validate.argumentsAreNotNull(javaType, newType);
        this.mappedTypes.put(javaType.toString(), newType);
        if (newType instanceof ManagedType) {
            ManagedType managedType = (ManagedType)newType;
            this.mappedTypeNames.put(new DuckType(managedType.getName()), ReflectionUtil.extractClass(javaType));
            this.mappedTypeNames.put(new DuckType(managedType), ReflectionUtil.extractClass(javaType));
        }
    }

    JaversType get(Type javaType) {
        return this.mappedTypes.get(javaType.toString());
    }

    boolean contains(Type javaType) {
        return this.get(javaType) != null;
    }

    Class getClassByTypeName(String typeName) {
        return this.getClassByDuckType(new DuckType(typeName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class getClassByDuckType(DuckType duckType) {
        Validate.argumentsAreNotNull(duckType);
        Class javaType = this.mappedTypeNames.get(duckType);
        if (javaType != null) {
            return javaType;
        }
        String string = duckType.getTypeName();
        synchronized (string) {
            Optional<? extends Class> classForName = this.parseClass(duckType.getTypeName());
            if (classForName.isPresent()) {
                this.mappedTypeNames.put(duckType, classForName.get());
                return classForName.get();
            }
        }
        if (!duckType.isBare()) {
            return this.getClassByDuckType(duckType.bareCopy());
        }
        throw new JaversException(JaversExceptionCode.TYPE_NAME_NOT_FOUND, duckType.getTypeName());
    }

    private Optional<? extends Class> parseClass(String qualifiedName) {
        try {
            this.getClass();
            return Optional.of(Class.forName(qualifiedName));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }
}

