/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import org.javers.common.collections.Primitives;
import org.javers.core.diff.custom.CustomValueComparator;
import org.javers.core.metamodel.type.ClassType;

public abstract class PrimitiveOrValueType
extends ClassType {
    private final CustomValueComparator valueComparator;

    PrimitiveOrValueType(Type baseJavaType) {
        this(baseJavaType, (CustomValueComparator)null);
    }

    PrimitiveOrValueType(Type baseJavaType, CustomValueComparator customValueComparator) {
        super(baseJavaType);
        this.valueComparator = customValueComparator == null ? (x$0, x$1) -> super.equals(x$0, x$1) : customValueComparator;
    }

    @Override
    public boolean equals(Object left, Object right) {
        return this.valueComparator.equals(left, right);
    }

    public boolean isNumber() {
        return Number.class.isAssignableFrom(this.getBaseJavaClass()) || Primitives.isPrimitiveNumber(this.getBaseJavaClass());
    }

    public boolean isBoolean() {
        return Boolean.class == this.getBaseJavaClass() || Boolean.TYPE == this.getBaseJavaClass();
    }

    public boolean isStringy() {
        return String.class == this.getBaseJavaClass() || CharSequence.class == this.getBaseJavaClass() || Character.TYPE == this.getBaseJavaClass() || Character.class == this.getBaseJavaClass();
    }

    public boolean isJsonPrimitive() {
        return this.isStringy() || this.isBoolean() || this.isNumber();
    }

    public abstract String smartToString(Object var1);
}

