/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.javers.common.collections.Lists;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.string.PrettyPrintBuilder;
import org.javers.common.string.ToStringBuilder;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.InstanceIdFactory;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.ManagedClass;
import org.javers.core.metamodel.type.ManagedType;

public class EntityType
extends ManagedType {
    private final List<JaversProperty> idProperties;
    private final InstanceIdFactory instanceIdFactory;

    EntityType(ManagedClass entity, List<JaversProperty> idProperties, Optional<String> typeName) {
        super(entity, typeName);
        Validate.argumentIsNotNull(idProperties);
        Validate.argumentCheck(idProperties.size() > 0, "no idProperties in " + entity.getBaseJavaClass());
        this.idProperties = Lists.immutableCopyOf(idProperties);
        this.instanceIdFactory = new InstanceIdFactory(this);
    }

    @Override
    EntityType spawn(ManagedClass managedClass, Optional<String> typeName) {
        return new EntityType(managedClass, managedClass.getProperties(this.getIdPropertyNames()), typeName);
    }

    public List<JaversProperty> getIdProperties() {
        return this.idProperties;
    }

    public JaversProperty getIdProperty() {
        Validate.conditionFulfilled(!this.hasCompositeId(), "getIdProperty() can't be called on Entity with Composite Id");
        return this.idProperties.get(0);
    }

    public boolean hasCompositeId() {
        return this.idProperties.size() > 1;
    }

    private List<String> getIdPropertyNames() {
        return this.idProperties.stream().map(Property::getName).collect(Collectors.toList());
    }

    public boolean isIdProperty(JaversProperty property) {
        return this.idProperties.contains(property);
    }

    public Object getIdOf(Object instance) {
        Validate.argumentIsNotNull(instance);
        if (!this.isInstance(instance)) {
            throw new JaversException(JaversExceptionCode.NOT_INSTANCE_OF, this.getName(), this.getBaseJavaClass().getName(), instance.getClass().getName());
        }
        if (this.hasCompositeId()) {
            Map<String, Object> compositeId = Collections.unmodifiableMap(this.idProperties.stream().filter(p -> p.get(instance) != null).collect(Collectors.toMap(p -> p.getName(), p -> p.get(instance))));
            if (compositeId.isEmpty()) {
                throw new JaversException(JaversExceptionCode.ENTITY_INSTANCE_WITH_NULL_COMPOSITE_ID, this.getName(), this.getIdPropertyNames());
            }
            return Collections.unmodifiableMap(compositeId);
        }
        Object cdoId = this.getIdProperty().get(instance);
        if (cdoId == null) {
            throw new JaversException(JaversExceptionCode.ENTITY_INSTANCE_WITH_NULL_ID, this.getName(), this.getIdProperty().getName());
        }
        return cdoId;
    }

    public InstanceId createIdFromInstance(Object instance) {
        Object localId = this.getIdOf(instance);
        return this.instanceIdFactory.create(localId);
    }

    public InstanceId createIdFromInstanceId(Object localId) {
        return this.instanceIdFactory.create(localId);
    }

    public InstanceId createIdFromDehydratedLocalId(Object dehydratedLocalId) {
        return this.instanceIdFactory.createFromDehydratedLocalId(dehydratedLocalId);
    }

    InstanceIdFactory getInstanceIdFactory() {
        return this.instanceIdFactory;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityType)) {
            return false;
        }
        EntityType that = (EntityType)o;
        return super.equals(that) && this.idProperties.equals(that.idProperties);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.idProperties.hashCode();
    }

    @Override
    public String toString() {
        return ToStringBuilder.toString(this, "baseType", this.getBaseJavaType(), "id", this.getIdPropertyNames());
    }

    @Override
    protected PrettyPrintBuilder prettyPrintBuilder() {
        return super.prettyPrintBuilder().addField("idProperties", this.getIdPropertyNames());
    }

    public Type getLocalIdDehydratedType() {
        return this.instanceIdFactory.getLocalIdDehydratedType();
    }
}

