/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import org.javers.common.collections.Primitives;
import org.javers.core.diff.custom.CustomValueComparator;
import org.javers.core.metamodel.type.ClassType;
import org.javers.core.metamodel.type.CustomComparableType;
import org.javers.core.metamodel.type.CustomValueComparatorNullSafe;

public abstract class PrimitiveOrValueType<T>
extends ClassType
implements CustomComparableType {
    private final CustomValueComparatorNullSafe<T> valueComparator;

    @Override
    public boolean hasCustomValueComparator() {
        return this.valueComparator != null;
    }

    PrimitiveOrValueType(Type baseJavaType) {
        this(baseJavaType, (CustomValueComparator<T>)null);
    }

    PrimitiveOrValueType(Type baseJavaType, CustomValueComparator<T> comparator) {
        super(baseJavaType);
        this.valueComparator = comparator == null ? null : new CustomValueComparatorNullSafe<T>(comparator);
    }

    @Override
    public boolean equals(Object left, Object right) {
        if (this.valueComparator != null) {
            return this.valueComparator.equals(left, right);
        }
        return super.equals(left, right);
    }

    public boolean isNumber() {
        return Number.class.isAssignableFrom(this.getBaseJavaClass()) || Primitives.isPrimitiveNumber(this.getBaseJavaClass());
    }

    public boolean isBoolean() {
        return Boolean.class == this.getBaseJavaClass() || Boolean.TYPE == this.getBaseJavaClass();
    }

    public boolean isStringy() {
        return String.class == this.getBaseJavaClass() || CharSequence.class == this.getBaseJavaClass() || Character.TYPE == this.getBaseJavaClass() || Character.class == this.getBaseJavaClass();
    }

    public boolean isJsonPrimitive() {
        return this.isStringy() || this.isBoolean() || this.isNumber();
    }

    CustomValueComparator getValueComparator() {
        return this.valueComparator;
    }
}

