/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.PrimitiveOrValueType;
import org.javers.core.metamodel.type.ValueObjectType;

class InstanceIdFactory {
    private final EntityType entityType;

    InstanceIdFactory(EntityType entityType) {
        this.entityType = entityType;
    }

    InstanceId create(Object localId) {
        Validate.argumentsAreNotNull(this.entityType, localId);
        DehydratedLocalId dehydratedLocalId = this.dehydratedLocalId(localId);
        return new InstanceId(this.entityType.getName(), dehydratedLocalId.getId(), dehydratedLocalId.toLocalIdString());
    }

    InstanceId createFromDehydratedJsonLocalId(Object dehydratedLocalId) {
        Validate.argumentsAreNotNull(this.entityType, dehydratedLocalId);
        String localIdAsString = this.localIdAsStringFromJson(dehydratedLocalId);
        return new InstanceId(this.entityType.getName(), dehydratedLocalId, localIdAsString);
    }

    private String localIdAsStringFromJson(Object dehydratedJsonLocalId) {
        if (dehydratedJsonLocalId instanceof String) {
            return (String)dehydratedJsonLocalId;
        }
        JaversProperty idProperty = this.entityType.getIdProperty();
        if (idProperty.isEntityType()) {
            EntityType idPropertyType = (EntityType)idProperty.getType();
            return idPropertyType.getInstanceIdFactory().localIdAsStringFromJson(dehydratedJsonLocalId);
        }
        if (idProperty.isValueObjectType()) {
            ValueObjectType valueObjectType = (ValueObjectType)idProperty.getType();
            return valueObjectType.smartToString(dehydratedJsonLocalId);
        }
        if (idProperty.isPrimitiveOrValueType()) {
            PrimitiveOrValueType primitiveOrValueType = (PrimitiveOrValueType)idProperty.getType();
            return primitiveOrValueType.valueToString(dehydratedJsonLocalId);
        }
        throw this.idTypeNotSupported();
    }

    private DehydratedLocalId dehydratedLocalId(JaversProperty idProperty, Object localId) {
        if (idProperty.isEntityType()) {
            EntityType idPropertyType = (EntityType)idProperty.getType();
            return idPropertyType.getInstanceIdFactory().dehydratedLocalId(idPropertyType.getIdOf(localId));
        }
        if (idProperty.isValueObjectType()) {
            ValueObjectType valueObjectType = (ValueObjectType)idProperty.getType();
            String localIdAsString = valueObjectType.smartToString(localId);
            return new SimpleDehydratedLocalId(localIdAsString, valueObjectType.smartToString(localId));
        }
        if (idProperty.isPrimitiveOrValueType()) {
            PrimitiveOrValueType primitiveOrValueType = (PrimitiveOrValueType)idProperty.getType();
            return new SimpleDehydratedLocalId(localId, primitiveOrValueType.valueToString(localId));
        }
        throw this.idTypeNotSupported();
    }

    private DehydratedLocalId dehydratedLocalId(Object localId) {
        if (this.entityType.hasCompositeId()) {
            Map compositeLocalId = (Map)localId;
            return new CompositeDehydratedLocalId(compositeLocalId.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> this.dehydratedLocalId(this.entityType.getProperty((String)e.getKey()), e.getValue())).collect(Collectors.toList()));
        }
        return this.dehydratedLocalId(this.entityType.getIdProperty(), localId);
    }

    private JaversException idTypeNotSupported() {
        return new JaversException(JaversExceptionCode.ID_TYPE_NOT_SUPPORTED, this.entityType.getIdProperty().getType().getClass().getSimpleName(), ((JaversType)this.entityType.getIdProperty().getType()).getName(), this.entityType.getBaseJavaClass().getName());
    }

    Type getLocalIdDehydratedJsonType() {
        if (this.entityType.hasCompositeId()) {
            return String.class;
        }
        JaversProperty idProperty = this.entityType.getIdProperty();
        if (idProperty.isEntityType()) {
            EntityType idPropertyType = (EntityType)idProperty.getType();
            return idPropertyType.getLocalIdDehydratedJsonType();
        }
        if (idProperty.isValueObjectType()) {
            return String.class;
        }
        if (idProperty.isPrimitiveOrValueType()) {
            return idProperty.getGenericType();
        }
        throw this.idTypeNotSupported();
    }

    private static class CompositeDehydratedLocalId
    implements DehydratedLocalId {
        private final List<DehydratedLocalId> dehydratedLocalIds;

        private CompositeDehydratedLocalId(List<DehydratedLocalId> dehydratedLocalIds) {
            this.dehydratedLocalIds = dehydratedLocalIds;
        }

        @Override
        public Object getId() {
            return this.toLocalIdString();
        }

        @Override
        public String toLocalIdString() {
            return String.join((CharSequence)",", this.dehydratedLocalIds.stream().map(it -> it.toLocalIdString()).collect(Collectors.toList()));
        }
    }

    private static class SimpleDehydratedLocalId
    implements DehydratedLocalId {
        private final Object localId;
        private final String localIdAsString;

        private SimpleDehydratedLocalId(Object localId, String localIdAsString) {
            this.localId = localId;
            this.localIdAsString = localIdAsString;
        }

        @Override
        public String toLocalIdString() {
            return this.localIdAsString;
        }

        @Override
        public Object getId() {
            return this.localId;
        }
    }

    private static interface DehydratedLocalId {
        public String toLocalIdString();

        public Object getId();
    }
}

