/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.util.Optional;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.metamodel.type.ManagedClass;
import org.javers.core.metamodel.type.ManagedType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnknownType
extends ManagedType {
    public static final Logger logger = LoggerFactory.getLogger(UnknownType.class);

    public UnknownType(String typeName) {
        super(ManagedClass.unknown(), Optional.of(typeName));
        logger.warn("Missing class definition with @TypeName '" + typeName + "', \ncant't properly deserialize its Snapshots from JaversRepository.\nTo fix this issue provide the fully-qualified package name of the class named '" + typeName + "' in the packagesToScan property.");
    }

    @Override
    ManagedType spawn(ManagedClass managedClass, Optional<String> typeName) {
        throw new JaversException(JaversExceptionCode.NOT_IMPLEMENTED, new Object[0]);
    }
}

