/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.javers.common.validation.Validate;
import org.javers.core.graph.Cdo;
import org.javers.core.graph.LiveCdoFactory;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.core.metamodel.object.ValueObjectIdWithHash;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.ManagedType;

abstract class LiveCdo
extends Cdo {
    private GlobalId globalId;

    LiveCdo(GlobalId globalId, ManagedType managedType) {
        super(managedType);
        this.globalId = globalId;
    }

    void enrichHashIfNeeded(LiveCdoFactory liveCdoFactory, Supplier<List<LiveCdo>> descendants) {
        if (this.requiresObjectHasher()) {
            List<LiveCdo> descendantVOs = descendants.get().stream().filter(cdo -> cdo.getGlobalId() instanceof ValueObjectId).collect(Collectors.toList());
            ValueObjectId newId = liveCdoFactory.regenerateValueObjectHash(this, descendantVOs);
            this.swapId(newId);
        }
    }

    void reloadHashFromParentIfNeeded(LiveCdoFactory liveCdoFactory) {
        if (this.hasHashOnParent()) {
            ValueObjectIdWithHash id = (ValueObjectIdWithHash)this.getGlobalId();
            this.swapId(id.freeze());
        }
    }

    @Override
    public GlobalId getGlobalId() {
        return this.globalId;
    }

    @Override
    public Object getPropertyValue(String propertyName) {
        Validate.argumentIsNotNull(propertyName);
        JaversProperty property = this.getManagedType().getProperty(propertyName);
        return this.getPropertyValue(property);
    }

    @Override
    public Object getPropertyValue(Property property) {
        Validate.argumentIsNotNull(property);
        return property.get(this.wrappedCdo());
    }

    @Override
    public Optional<Object> getWrappedCdo() {
        return Optional.of(this.wrappedCdo());
    }

    @Override
    public boolean isNull(Property property) {
        Validate.argumentIsNotNull(property);
        return property.isNull(this.wrappedCdo());
    }

    abstract Object wrappedCdo();

    private boolean requiresObjectHasher() {
        return this.globalId instanceof ValueObjectIdWithHash && ((ValueObjectIdWithHash)this.getGlobalId()).requiresHash();
    }

    private boolean hasHashOnParent() {
        return this.globalId instanceof ValueObjectIdWithHash && ((ValueObjectIdWithHash)this.getGlobalId()).hasHashOnParent();
    }

    private void swapId(GlobalId globalId) {
        this.globalId = globalId;
    }
}

