/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import org.javers.common.collections.EnumerableFunction;
import org.javers.core.graph.AbstractMultiEdge;
import org.javers.core.graph.AbstractSingleEdge;
import org.javers.core.graph.LiveCdo;
import org.javers.core.graph.LiveCdoFactory;
import org.javers.core.graph.LiveNode;
import org.javers.core.graph.MultiEdge;
import org.javers.core.graph.NodeReuser;
import org.javers.core.graph.ObjectNode;
import org.javers.core.graph.ShallowMultiEdge;
import org.javers.core.graph.ShallowSingleEdge;
import org.javers.core.graph.SingleEdge;
import org.javers.core.metamodel.object.OwnerContext;
import org.javers.core.metamodel.object.PropertyOwnerContext;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.EnumerableType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.KeyValueType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.MapEnumerationOwnerContext;
import org.javers.core.metamodel.type.ShallowReferenceType;
import org.javers.core.metamodel.type.TypeMapper;

class EdgeBuilder {
    private final TypeMapper typeMapper;
    private final NodeReuser nodeReuser;
    private final LiveCdoFactory cdoFactory;

    EdgeBuilder(TypeMapper typeMapper, NodeReuser nodeReuser, LiveCdoFactory cdoFactory) {
        this.typeMapper = typeMapper;
        this.nodeReuser = nodeReuser;
        this.cdoFactory = cdoFactory;
    }

    AbstractSingleEdge buildSingleEdge(ObjectNode node, JaversProperty singleRef) {
        Object rawReference = node.getPropertyValue(singleRef);
        OwnerContext ownerContext = this.createOwnerContext(node, singleRef);
        if (!singleRef.isShallowReference()) {
            LiveCdo cdo = this.cdoFactory.create(rawReference, ownerContext);
            LiveNode targetNode = this.buildNodeStubOrReuse(cdo);
            return new SingleEdge(singleRef, targetNode);
        }
        return new ShallowSingleEdge(singleRef, this.cdoFactory.createId(rawReference, ownerContext));
    }

    private OwnerContext createOwnerContext(ObjectNode parentNode, JaversProperty property) {
        return new PropertyOwnerContext(parentNode.getGlobalId(), property.getName());
    }

    AbstractMultiEdge createMultiEdge(JaversProperty containerProperty, EnumerableType enumerableType, ObjectNode node) {
        OwnerContext owner = this.createOwnerContext(node, containerProperty);
        Object container = node.getPropertyValue(containerProperty);
        boolean isShallow = containerProperty.isShallowReference() || this.hasShallowReferenceItems(enumerableType);
        EnumerableFunction<Object, Object> itemMapper = (input, context) -> {
            MapEnumerationOwnerContext mapContext;
            if (context instanceof MapEnumerationOwnerContext && !((mapContext = (MapEnumerationOwnerContext)context).getCurrentType() instanceof ManagedType)) {
                return input;
            }
            if (!isShallow) {
                LiveCdo cdo = this.cdoFactory.create(input, context);
                return this.buildNodeStubOrReuse(cdo);
            }
            return this.cdoFactory.createId(input, context);
        };
        Object mappedEnumerable = enumerableType.map(container, itemMapper, owner);
        if (!isShallow) {
            return new MultiEdge(containerProperty, mappedEnumerable);
        }
        return new ShallowMultiEdge(containerProperty, mappedEnumerable);
    }

    private boolean hasShallowReferenceItems(EnumerableType enumerableType) {
        if (enumerableType instanceof ContainerType) {
            ContainerType containerType = (ContainerType)enumerableType;
            return containerType.getItemJaversType() instanceof ShallowReferenceType;
        }
        if (enumerableType instanceof KeyValueType) {
            KeyValueType keyValueType = (KeyValueType)enumerableType;
            return keyValueType.getKeyJaversType() instanceof ShallowReferenceType || keyValueType.getValueJaversType() instanceof ShallowReferenceType;
        }
        return false;
    }

    private LiveNode buildNodeStubOrReuse(LiveCdo cdo) {
        if (this.nodeReuser.isReusable(cdo)) {
            return this.nodeReuser.getForReuse(cdo);
        }
        return this.buildNodeStub(cdo);
    }

    LiveNode buildNodeStub(LiveCdo cdo) {
        LiveNode newStub = new LiveNode(cdo);
        this.nodeReuser.enqueueStub(newStub);
        return newStub;
    }
}

