/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.javers.common.collections.Primitives;
import org.javers.common.collections.WellKnownValueTypes;
import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.common.reflection.ReflectionUtil;
import org.javers.common.validation.Validate;
import org.javers.core.diff.ListCompareAlgorithm;
import org.javers.core.json.typeadapter.util.UtilTypeCoreAdapters;
import org.javers.core.metamodel.clazz.ClientsClassDefinition;
import org.javers.core.metamodel.type.ArrayType;
import org.javers.core.metamodel.type.ClassType;
import org.javers.core.metamodel.type.CollectionType;
import org.javers.core.metamodel.type.DuckType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.ListAsSetType;
import org.javers.core.metamodel.type.ListType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.MapType;
import org.javers.core.metamodel.type.OptionalType;
import org.javers.core.metamodel.type.PrimitiveType;
import org.javers.core.metamodel.type.SetType;
import org.javers.core.metamodel.type.TypeMapper;
import org.javers.core.metamodel.type.TypeMapperLazy;
import org.javers.core.metamodel.type.ValueType;
import org.javers.java8support.Java8TypeAdapters;
import org.slf4j.Logger;

class TypeMapperEngine {
    static final Logger logger = TypeMapper.logger;
    private static final Object LOCK_MAPPED_TYPES = new Object();
    private final Map<String, JaversType> mappedTypes = new ConcurrentHashMap<String, JaversType>();
    private final Map<DuckType, Class> mappedTypeNames = new ConcurrentHashMap<DuckType, Class>();
    private final TypeMapperLazy typeMapperlazy;

    TypeMapperEngine(TypeMapperLazy typeMapperlazy) {
        this.typeMapperlazy = typeMapperlazy;
    }

    private void putIfAbsent(Type javaType, JaversType jType) {
        Validate.argumentsAreNotNull(javaType, jType);
        if (this.contains(javaType)) {
            return;
        }
        this.addFullMapping(javaType, jType);
    }

    void registerCoreTypes(ListCompareAlgorithm listCompareAlgorithm, Collection<ClientsClassDefinition> classesToSkip) {
        ArrayList<ClassType> coreTypes = new ArrayList<ClassType>();
        Set classesToSkipAsSet = classesToSkip.stream().map(it -> it.getBaseJavaClass()).collect(Collectors.toSet());
        Primitives.getPrimitiveAndBoxTypes().forEach(primitiveOrBox -> coreTypes.add(new PrimitiveType((Type)primitiveOrBox)));
        coreTypes.add(new PrimitiveType((Type)((Object)Enum.class)));
        coreTypes.add(new ArrayType((Type)((Object)Object[].class), this.typeMapperlazy));
        WellKnownValueTypes.getOldGoodValueTypes().forEach(valueType -> coreTypes.add(new ValueType((Type)valueType)));
        coreTypes.addAll(UtilTypeCoreAdapters.valueTypes());
        coreTypes.addAll(Java8TypeAdapters.valueTypes());
        coreTypes.add(new CollectionType((Type)((Object)Collection.class), this.typeMapperlazy));
        coreTypes.add(new SetType((Type)((Object)Set.class), this.typeMapperlazy));
        if (listCompareAlgorithm == ListCompareAlgorithm.AS_SET) {
            coreTypes.add(new ListAsSetType((Type)((Object)List.class), this.typeMapperlazy));
        } else {
            coreTypes.add(new ListType((Type)((Object)List.class), this.typeMapperlazy));
        }
        coreTypes.add(new OptionalType(this.typeMapperlazy));
        coreTypes.add(new MapType((Type)((Object)Map.class), this.typeMapperlazy));
        coreTypes.stream().filter(it -> !classesToSkipAsSet.contains(it.getBaseJavaType())).forEach(it -> this.registerCoreType((JaversType)it));
    }

    void registerExplicitType(JaversType javersType) {
        this.putIfAbsent(javersType.getBaseJavaType(), javersType);
    }

    private void registerCoreType(JaversType jType) {
        logger.debug("registering coreType: {} -> {} ", (Object)jType.getBaseJavaType().getTypeName(), (Object)jType.getClass().getSimpleName());
        this.putIfAbsent(jType.getBaseJavaType(), jType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JaversType computeIfAbsent(Type javaType, Function<Type, JaversType> computeFunction) {
        JaversType javersType = this.get(javaType);
        if (javersType != null) {
            return javersType;
        }
        Object object = LOCK_MAPPED_TYPES;
        synchronized (object) {
            JaversType mappedType = this.get(javaType);
            if (mappedType != null) {
                return mappedType;
            }
            JaversType newType = computeFunction.apply(javaType);
            this.addFullMapping(javaType, newType);
            return newType;
        }
    }

    private void addFullMapping(Type javaType, JaversType newType) {
        Validate.argumentsAreNotNull(javaType, newType);
        JaversType existingType = this.mappedTypes.put(javaType.toString(), newType);
        if (existingType != null) {
            throw new JaversException(JaversExceptionCode.ATTEMPT_TO_OVERWRITE_EXISTING_JAVERSTYPE_MAPPING, javaType.toString(), existingType, newType);
        }
        if (newType instanceof ManagedType) {
            ManagedType managedType = (ManagedType)newType;
            this.mappedTypeNames.put(new DuckType(managedType.getName()), ReflectionUtil.extractClass(javaType));
            this.mappedTypeNames.put(new DuckType(managedType), ReflectionUtil.extractClass(javaType));
        }
    }

    JaversType get(Type javaType) {
        return this.mappedTypes.get(javaType.toString());
    }

    boolean contains(Type javaType) {
        return this.get(javaType) != null;
    }

    Class getClassByTypeName(String typeName) {
        return this.getClassByDuckType(new DuckType(typeName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Class getClassByDuckType(DuckType duckType) {
        Validate.argumentsAreNotNull(duckType);
        Class javaType = this.mappedTypeNames.get(duckType);
        if (javaType != null) {
            return javaType;
        }
        String string = duckType.getTypeName();
        synchronized (string) {
            Optional<? extends Class> classForName = this.parseClass(duckType.getTypeName());
            if (classForName.isPresent()) {
                this.mappedTypeNames.put(duckType, classForName.get());
                return classForName.get();
            }
        }
        if (!duckType.isBare()) {
            return this.getClassByDuckType(duckType.bareCopy());
        }
        throw new JaversException(JaversExceptionCode.TYPE_NAME_NOT_FOUND, duckType.getTypeName());
    }

    private Optional<? extends Class> parseClass(String qualifiedName) {
        try {
            this.getClass();
            return Optional.of(Class.forName(qualifiedName));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
    }
}

