/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.javers.core.graph.Cdo;
import org.javers.core.graph.LiveNode;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.InstanceId;
import org.javers.core.metamodel.object.ValueObjectId;

class NodeReuser {
    private final Map<GlobalId, LiveNode> reverseCdoIdMap = new HashMap<GlobalId, LiveNode>();
    private final Map<SystemIdentityWrapper, LiveNode> traversedObjects = new HashMap<SystemIdentityWrapper, LiveNode>();
    private final List<LiveNode> nodes = new ArrayList<LiveNode>();
    private final Queue<LiveNode> stubs = new LinkedList<LiveNode>();
    private int reusedNodes;
    private int entities;
    private int valueObjects;

    NodeReuser() {
    }

    boolean isReusable(Cdo cdo) {
        return this.reverseCdoIdMap.containsKey(this.reverseCdoIdMapKey(cdo));
    }

    boolean isTraversed(Cdo cdo) {
        return this.traversedObjects.containsKey(this.traversedObjectsMapKey(cdo));
    }

    LiveNode getForReuse(Cdo cdo) {
        ++this.reusedNodes;
        return this.reverseCdoIdMap.get(this.reverseCdoIdMapKey(cdo));
    }

    LiveNode getForDouble(Cdo cdo) {
        ++this.reusedNodes;
        return this.traversedObjects.get(this.traversedObjectsMapKey(cdo));
    }

    List<LiveNode> nodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    void saveForReuse(LiveNode reference) {
        if (reference.getGlobalId() instanceof InstanceId) {
            ++this.entities;
        }
        if (reference.getGlobalId() instanceof ValueObjectId) {
            ++this.valueObjects;
        }
        this.reverseCdoIdMap.put(this.reverseCdoIdMapKey((Cdo)reference.getCdo()), reference);
        this.traversedObjects.put(this.traversedObjectsMapKey((Cdo)reference.getCdo()), reference);
        this.nodes.add(reference);
    }

    void saveNodeDouble(LiveNode reference) {
        this.nodes.add(reference);
    }

    void enqueueStub(LiveNode nodeStub) {
        this.stubs.offer(nodeStub);
    }

    LiveNode pollStub() {
        return this.stubs.poll();
    }

    boolean hasMoreStubs() {
        return !this.stubs.isEmpty();
    }

    int nodesCount() {
        return this.reverseCdoIdMap.size();
    }

    int reusedNodesCount() {
        return this.reusedNodes;
    }

    int entitiesCount() {
        return this.entities;
    }

    int voCount() {
        return this.valueObjects;
    }

    private GlobalId reverseCdoIdMapKey(Cdo cdo) {
        return cdo.getGlobalId();
    }

    private SystemIdentityWrapper traversedObjectsMapKey(Cdo cdo) {
        return new SystemIdentityWrapper(cdo);
    }

    private static class SystemIdentityWrapper {
        private final Object wrappedObject;

        SystemIdentityWrapper(Cdo cdo) {
            this.wrappedObject = cdo.getWrappedCdo().get();
        }

        public boolean equals(Object o) {
            if (o == null || o.getClass() != SystemIdentityWrapper.class) {
                return false;
            }
            return this.wrappedObject == ((SystemIdentityWrapper)o).wrappedObject;
        }

        public int hashCode() {
            return System.identityHashCode(this.wrappedObject);
        }
    }
}

