/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.javers.common.collections.Lists;
import org.javers.core.graph.AbstractSingleEdge;
import org.javers.core.graph.Edge;
import org.javers.core.graph.LiveCdo;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.object.ValueObjectId;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.EnumerableType;
import org.javers.core.metamodel.type.JaversProperty;

public class LiveNode
extends ObjectNode<LiveCdo> {
    private final Map<String, Edge> edges = new HashMap<String, Edge>();

    public LiveNode(LiveCdo cdo) {
        super(cdo);
    }

    static LiveNode liveNodeDouble(LiveNode originalNode, LiveCdo cdoDouble) {
        LiveNode doubleNode = new LiveNode(cdoDouble);
        doubleNode.edges.putAll(originalNode.edges);
        return doubleNode;
    }

    Edge getEdge(Property property) {
        return this.getEdge(property.getName());
    }

    Edge getEdge(String propertyName) {
        return this.edges.get(propertyName);
    }

    @Override
    public boolean isEdge() {
        return false;
    }

    @Override
    public GlobalId getReference(Property property) {
        Edge edge = this.getEdge(property);
        if (edge instanceof AbstractSingleEdge) {
            return ((AbstractSingleEdge)edge).getReference();
        }
        return null;
    }

    @Override
    public List<GlobalId> getReferences(JaversProperty property) {
        Edge edge = this.getEdge(property);
        if (edge != null) {
            return edge.getReferences().stream().map(it -> it.getGlobalId()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    protected Object getDehydratedPropertyValue(String propertyName) {
        return this.getManagedType().findProperty(propertyName).map(p -> this.getDehydratedPropertyValue((JaversProperty)p)).orElse(null);
    }

    @Override
    public Object getDehydratedPropertyValue(JaversProperty property) {
        Edge edge = this.getEdge(property);
        if (edge != null) {
            return edge.getDehydratedPropertyValue();
        }
        Object propertyValue = ((LiveCdo)this.getCdo()).getPropertyValue(property);
        if (propertyValue == null) {
            return null;
        }
        if (property.getType() instanceof EnumerableType) {
            EnumerableType enumerableType = (EnumerableType)property.getType();
            return enumerableType.map(propertyValue, it -> it);
        }
        return ((LiveCdo)this.getCdo()).getPropertyValue(property);
    }

    void addEdge(Edge edge) {
        this.edges.put(edge.getProperty().getName(), edge);
    }

    Set<LiveCdo> descendants(int maxDepth) {
        return new NodeTraverser(this, maxDepth, null).descendantsList().stream().collect(Collectors.toUnmodifiableSet());
    }

    List<LiveCdo> descendantVOs(int maxDepth) {
        return new NodeTraverser(this, maxDepth, n -> n.getGlobalId() instanceof ValueObjectId).descendantsList();
    }

    public String toString() {
        return "LiveNode{" + this.hashCode() + ", globaId:" + this.getGlobalId() + ", edges:" + this.edges.size() + " }";
    }

    private static class NodeTraverser {
        private final Set<LiveNode> descendantsSet = new HashSet<LiveNode>();
        private final List<LiveCdo> descendantsList = new ArrayList<LiveCdo>();
        private final int maxDepth;
        private final ObjectNode root;
        private final Predicate<LiveNode> filter;

        NodeTraverser(LiveNode root, int maxDepth, Predicate<LiveNode> filter) {
            this.maxDepth = maxDepth;
            this.root = root;
            this.filter = filter != null ? filter : n -> true;
            this.followEdges(root, 1);
        }

        void follow(Edge edge, int depth) {
            edge.getReferences().forEach(reference -> {
                if (!this.descendantsSet.contains(reference) && !reference.equals(this.root) && this.filter.test((LiveNode)reference)) {
                    this.descendantsSet.add((LiveNode)reference);
                    this.descendantsList.add((LiveCdo)reference.getCdo());
                    if (depth < this.maxDepth) {
                        this.followEdges((LiveNode)reference, depth + 1);
                    }
                }
            });
        }

        List<LiveCdo> descendantsList() {
            return Lists.immutableListOf(this.descendantsList);
        }

        void followEdges(LiveNode node, int depth) {
            node.edges.values().forEach(e -> this.follow((Edge)e, depth));
        }
    }
}

