/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.diff.appenders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.javers.common.collections.Sets;
import org.javers.core.diff.NodePair;
import org.javers.core.diff.appenders.CorePropertyChangeAppender;
import org.javers.core.diff.appenders.HashWrapper;
import org.javers.core.diff.changetype.container.ContainerElementChange;
import org.javers.core.diff.changetype.container.SetChange;
import org.javers.core.diff.changetype.container.ValueAdded;
import org.javers.core.diff.changetype.container.ValueRemoved;
import org.javers.core.metamodel.type.CollectionType;
import org.javers.core.metamodel.type.ContainerType;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.SetType;

class SetChangeAppender
extends CorePropertyChangeAppender<SetChange> {
    SetChangeAppender() {
    }

    @Override
    public boolean supports(JaversType propertyType) {
        return propertyType instanceof SetType;
    }

    @Override
    protected SetChange calculateChanges(Object leftValue, Object rightValue, NodePair pair, JaversProperty property) {
        Set rightSet;
        Set leftSet = this.wrapValuesIfNeeded(this.toSet(leftValue), property);
        List<ContainerElementChange> entryChanges = this.calculateDiff(leftSet, rightSet = this.wrapValuesIfNeeded(this.toSet(rightValue), property));
        if (!entryChanges.isEmpty()) {
            CollectionType setType = (CollectionType)property.getType();
            SetChangeAppender.renderNotParametrizedWarningIfNeeded(setType.getItemJavaType(), "item", "Set", property);
            return new SetChange(pair.createPropertyChangeMetadata(property), entryChanges, this.toSet(leftValue), this.toSet(rightValue));
        }
        return null;
    }

    private Set wrapValuesIfNeeded(Set set, JaversProperty property) {
        JaversType itemType = ((ContainerType)property.getType()).getItemJaversType();
        return HashWrapper.wrapValuesIfNeeded(set, itemType);
    }

    private Set toSet(Object collection) {
        if (collection instanceof Set) {
            return (Set)collection;
        }
        return new HashSet((Collection)collection);
    }

    private List<ContainerElementChange> calculateDiff(Set leftSet, Set rightSet) {
        if (Objects.equals(leftSet, rightSet)) {
            return Collections.emptyList();
        }
        ArrayList<ContainerElementChange> changes = new ArrayList<ContainerElementChange>();
        Sets.difference(leftSet, rightSet).forEach(valueOrId -> changes.add(new ValueRemoved(valueOrId)));
        Sets.difference(rightSet, leftSet).forEach(valueOrId -> changes.add(new ValueAdded(valueOrId)));
        return changes;
    }
}

