/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.clazz;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.clazz.ClientsClassDefinitionBuilder;
import org.javers.core.metamodel.clazz.PropertiesFilter;

public abstract class ClientsClassDefinition {
    private final Class<?> baseJavaClass;
    private final Optional<String> typeName;
    private final PropertiesFilter propertiesFilter;

    ClientsClassDefinition(Class<?> baseJavaClass) {
        this(baseJavaClass, Collections.emptyList(), Optional.empty(), Collections.emptyList(), Collections.emptyList());
    }

    ClientsClassDefinition(Class<?> baseJavaClass, List<String> ignoredProperties) {
        this(baseJavaClass, ignoredProperties, Optional.empty(), Collections.emptyList(), Collections.emptyList());
    }

    ClientsClassDefinition(ClientsClassDefinitionBuilder builder) {
        this(builder.getClazz(), builder.getIgnoredProperties(), builder.getTypeName(), builder.getIncludedProperties(), builder.getShallowProperties());
    }

    private ClientsClassDefinition(Class<?> baseJavaClass, List<String> ignoredProperties, Optional<String> typeName, List<String> includedProperties, List<String> shallowProperties) {
        Validate.argumentsAreNotNull(baseJavaClass, typeName, ignoredProperties, includedProperties);
        Validate.argumentCheck(includedProperties.size() <= 0 || ignoredProperties.size() <= 0, "Can't create ClientsClassDefinition for " + baseJavaClass.getSimpleName() + ", you can't define both ignored and included properties");
        this.baseJavaClass = baseJavaClass;
        this.typeName = typeName;
        this.propertiesFilter = new PropertiesFilter(includedProperties, ignoredProperties, shallowProperties);
    }

    public Class<?> getBaseJavaClass() {
        return this.baseJavaClass;
    }

    public boolean equals(Object o) {
        if (this == o || this.getClass() != o.getClass()) {
            return false;
        }
        ClientsClassDefinition that = (ClientsClassDefinition)o;
        return this.baseJavaClass.equals(that.baseJavaClass);
    }

    public int hashCode() {
        return this.baseJavaClass.hashCode();
    }

    public Optional<String> getTypeName() {
        return this.typeName;
    }

    public boolean hasTypeName() {
        return this.typeName.isPresent();
    }

    public PropertiesFilter getPropertiesFilter() {
        return this.propertiesFilter;
    }
}

