/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.graph;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.javers.core.graph.Cdo;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.object.GlobalId;

public abstract class ObjectGraph<T extends Cdo> {
    private final Set<ObjectNode<T>> nodes;

    protected ObjectGraph(Set<ObjectNode<T>> nodes) {
        this.nodes = Collections.unmodifiableSet(nodes);
    }

    public Set<ObjectNode<T>> nodes() {
        return this.nodes;
    }

    public Set<T> cdos() {
        return this.nodes().stream().map(node -> node.getCdo()).collect(Collectors.toSet());
    }

    public Set<GlobalId> globalIds() {
        return this.nodes().stream().map(ObjectNode::getGlobalId).collect(Collectors.toSet());
    }

    public Optional<T> get(GlobalId globalId) {
        return this.nodes.stream().filter(node -> globalId.equals(node.getGlobalId())).findFirst().map(node -> node.getCdo());
    }
}

