/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.metamodel.type;

import java.util.function.Supplier;
import org.javers.common.reflection.JaversMember;
import org.javers.common.string.ToStringBuilder;
import org.javers.core.metamodel.property.Property;
import org.javers.core.metamodel.type.CustomType;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.JaversType;
import org.javers.core.metamodel.type.PrimitiveOrValueType;
import org.javers.core.metamodel.type.ShallowReferenceType;
import org.javers.core.metamodel.type.ValueObjectType;

public class JaversProperty
extends Property {
    private final Supplier<JaversType> propertyType;
    private final boolean isListedAsShallowReference;

    public JaversProperty(Supplier<JaversType> propertyType, Property property) {
        this(propertyType, property.getMember(), property.hasTransientAnn(), property.hasShallowReferenceAnn(), property.getName(), property.isHasIncludedAnn(), false);
    }

    private JaversProperty(Supplier<JaversType> propertyType, JaversMember member, boolean hasTransientAnn, boolean hasShallowReferenceAnn, String name, boolean hasIncludedAnn, boolean isListedAsShallowReference) {
        super(member, hasTransientAnn, hasShallowReferenceAnn, name, hasIncludedAnn);
        this.propertyType = propertyType;
        this.isListedAsShallowReference = isListedAsShallowReference;
    }

    public <T extends JaversType> T getType() {
        return (T)this.propertyType.get();
    }

    public boolean isEntityType() {
        return this.getType() instanceof EntityType;
    }

    public boolean isValueObjectType() {
        return this.getType() instanceof ValueObjectType;
    }

    public boolean isPrimitiveOrValueType() {
        return this.getType() instanceof PrimitiveOrValueType;
    }

    public boolean isCustomType() {
        return this.getType() instanceof CustomType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JaversProperty that = (JaversProperty)o;
        return super.equals(that) && ((JaversType)this.getType()).equals(that.getType());
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean isShallowReference() {
        return this.hasShallowReferenceAnn() || this.getType() instanceof ShallowReferenceType || this.isListedAsShallowReference;
    }

    public JaversProperty copyAsShallowReference() {
        return new JaversProperty(this.propertyType, this.getMember(), this.hasTransientAnn(), this.hasShallowReferenceAnn(), this.getName(), this.isHasIncludedAnn(), true);
    }

    @Override
    public String toString() {
        return this.getMember().memberType() + " " + this.getName() + (this.getMember().memberType().equals("Getter") ? "()" : "") + " " + ToStringBuilder.typeName(this.getMember().getGenericResolvedType()) + ", javersType: " + this.getType().getClass().getSimpleName() + ", " + (this.isShallowReference() ? "@ShallowReference, " : "") + "declared in: " + this.getDeclaringClass().getSimpleName();
    }
}

