/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.commit;

import java.time.Instant;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.javers.common.validation.Validate;
import org.javers.core.Changes;
import org.javers.core.commit.CommitId;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.diff.Diff;
import org.javers.core.metamodel.object.CdoSnapshot;

public final class Commit {
    private final CommitMetadata commitMetadata;
    private final List<CdoSnapshot> snapshots;
    private final Diff diff;

    Commit(CommitMetadata commitMetadata, List<CdoSnapshot> snapshots, Diff diff) {
        Validate.argumentsAreNotNull(commitMetadata, snapshots, diff);
        this.commitMetadata = commitMetadata;
        this.snapshots = snapshots;
        this.diff = diff;
    }

    public CommitId getId() {
        return this.commitMetadata.getId();
    }

    public String getAuthor() {
        return this.commitMetadata.getAuthor();
    }

    public Map<String, String> getProperties() {
        return this.commitMetadata.getProperties();
    }

    Diff getDiff() {
        return this.diff;
    }

    public LocalDateTime getCommitDate() {
        return this.commitMetadata.getCommitDate();
    }

    public Instant getCommitDateInstant() {
        return this.commitMetadata.getCommitDateInstant();
    }

    public List<CdoSnapshot> getSnapshots() {
        return Collections.unmodifiableList(this.snapshots);
    }

    public Changes getChanges() {
        return this.diff.getChanges();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Commit(id:" + String.valueOf(this.commitMetadata.getId()));
        b.append(", snapshots:" + this.snapshots.size());
        b.append(", author:" + this.commitMetadata.getAuthor());
        b.append(", " + this.diff.changesSummary());
        b.append(")");
        return b.toString();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Commit other = (Commit)o;
        return this.getId().equals(other.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

