/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.snapshot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.javers.common.validation.Validate;
import org.javers.core.commit.CommitMetadata;
import org.javers.core.graph.LiveGraph;
import org.javers.core.graph.LiveNode;
import org.javers.core.graph.ObjectNode;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.type.JaversProperty;
import org.javers.core.snapshot.SnapshotFactory;
import org.javers.core.snapshot.SnapshotGraphFactory;

public class ChangedCdoSnapshotsFactory {
    private final SnapshotFactory snapshotFactory;
    private final SnapshotGraphFactory snapshotGraphFactory;

    ChangedCdoSnapshotsFactory(SnapshotFactory snapshotFactory, SnapshotGraphFactory snapshotGraphFactory) {
        this.snapshotFactory = snapshotFactory;
        this.snapshotGraphFactory = snapshotGraphFactory;
    }

    public List<CdoSnapshot> create(LiveGraph liveGraph, Set<CdoSnapshot> latestSnapshots, CommitMetadata commitMetadata) {
        Validate.argumentsAreNotNull(liveGraph, commitMetadata, latestSnapshots);
        ArrayList<CdoSnapshot> result = new ArrayList<CdoSnapshot>();
        for (ObjectNode node : liveGraph.nodes()) {
            CdoSnapshot currentSnapshot;
            LiveNode liveNode = (LiveNode)node;
            Object currentCdo = node.getCdo();
            Optional<CdoSnapshot> previousSnapshot = latestSnapshots.stream().filter(arg_0 -> currentCdo.equals(arg_0)).findFirst();
            if (!this.isCdoChanged(previousSnapshot, currentSnapshot = this.createSnapshot(commitMetadata, liveNode, previousSnapshot))) continue;
            result.add(currentSnapshot);
            result.addAll(this.createTerminalVoSnapshots(previousSnapshot, currentSnapshot, commitMetadata));
        }
        return result;
    }

    private List<CdoSnapshot> createTerminalVoSnapshots(Optional<CdoSnapshot> previousSnapshot, CdoSnapshot currentSnapshot, CommitMetadata commitMetadata) {
        if (!previousSnapshot.isPresent()) {
            return Collections.emptyList();
        }
        ArrayList<GlobalId> removedVO = new ArrayList<GlobalId>();
        for (JaversProperty property : currentSnapshot.getManagedType().getProperties()) {
            if (!property.isValueObjectType()) continue;
            Object oldVal = previousSnapshot.get().getPropertyValue(property);
            Object newVal = currentSnapshot.getPropertyValue(property);
            if (oldVal == null || newVal != null) continue;
            removedVO.add((GlobalId)oldVal);
        }
        return this.snapshotGraphFactory.loadLatest(removedVO).stream().map(s -> this.snapshotFactory.createTerminal(s.getGlobalId(), (CdoSnapshot)s, commitMetadata)).collect(Collectors.toList());
    }

    private CdoSnapshot createSnapshot(CommitMetadata commitMetadata, LiveNode liveNode, Optional<CdoSnapshot> previousSnapshot) {
        return this.isNewlyCreated(previousSnapshot) ? this.createInitialSnapshot(commitMetadata, liveNode) : this.createUpdateSnapshot(commitMetadata, liveNode, previousSnapshot.get());
    }

    private boolean isNewlyCreated(Optional<CdoSnapshot> previousSnapshot) {
        return !previousSnapshot.isPresent();
    }

    private CdoSnapshot createInitialSnapshot(CommitMetadata commitMetadata, LiveNode liveNode) {
        return this.snapshotFactory.createInitial(liveNode, commitMetadata);
    }

    private CdoSnapshot createUpdateSnapshot(CommitMetadata commitMetadata, LiveNode liveNode, CdoSnapshot previousSnapshot) {
        return this.snapshotFactory.createUpdate(liveNode, previousSnapshot, commitMetadata);
    }

    private boolean isCdoChanged(Optional<CdoSnapshot> previousSnapshot, CdoSnapshot currentSnapshot) {
        return !previousSnapshot.isPresent() || !previousSnapshot.get().stateEquals(currentSnapshot);
    }
}

