/*
 * Decompiled with CFR 0.152.
 */
package org.javers.core.snapshot;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.javers.common.validation.Validate;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.snapshot.SnapshotGraph;
import org.javers.core.snapshot.SnapshotNode;
import org.javers.repository.api.JaversExtendedRepository;

public class SnapshotGraphFactory {
    private final JaversExtendedRepository javersRepository;

    SnapshotGraphFactory(JaversExtendedRepository javersRepository) {
        this.javersRepository = javersRepository;
    }

    public List<CdoSnapshot> loadLatest(Collection<GlobalId> globalIds) {
        Validate.argumentIsNotNull(globalIds);
        return this.javersRepository.getLatest(globalIds).stream().collect(Collectors.toList());
    }

    public SnapshotGraph loadLatestAndCreateGraph(Set<GlobalId> globalIds) {
        Validate.argumentIsNotNull(globalIds);
        Set<SnapshotNode> snapshotNodes = this.javersRepository.getLatest(globalIds).stream().map(SnapshotNode::new).collect(Collectors.toSet());
        return new SnapshotGraph(snapshotNodes);
    }
}

