/*
 * Decompiled with CFR 0.152.
 */
package org.javers.repository.mongo;

import com.google.gson.JsonObject;
import com.mongodb.BasicDBObject;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.javers.common.collections.Lists;
import org.javers.common.string.RegexEscape;
import org.javers.common.validation.Validate;
import org.javers.core.commit.Commit;
import org.javers.core.commit.CommitId;
import org.javers.core.json.JsonConverter;
import org.javers.core.json.typeadapter.util.UtilTypeCoreAdapters;
import org.javers.core.metamodel.object.CdoSnapshot;
import org.javers.core.metamodel.object.GlobalId;
import org.javers.core.metamodel.type.EntityType;
import org.javers.core.metamodel.type.ManagedType;
import org.javers.core.metamodel.type.ValueObjectType;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.api.QueryParams;
import org.javers.repository.api.QueryParamsBuilder;
import org.javers.repository.api.SnapshotIdentifier;
import org.javers.repository.mongo.DocumentConverter;
import org.javers.repository.mongo.LatestSnapshotCache;
import org.javers.repository.mongo.MapKeyDotReplacer;
import org.javers.repository.mongo.MongoSchemaManager;
import org.javers.repository.mongo.model.MongoHeadId;

public class MongoRepository
implements JaversRepository {
    private static final int DEFAULT_CACHE_SIZE = 5000;
    private static final int DESC = -1;
    private final MongoSchemaManager mongoSchemaManager;
    private JsonConverter jsonConverter;
    private final MapKeyDotReplacer mapKeyDotReplacer = new MapKeyDotReplacer();
    private final LatestSnapshotCache cache;

    public MongoRepository(MongoDatabase mongo) {
        this(mongo, null, 5000);
    }

    public MongoRepository(MongoDatabase mongo, int cacheSize) {
        this(mongo, null, cacheSize);
    }

    MongoRepository(MongoDatabase mongo, JsonConverter jsonConverter, int cacheSize) {
        this.jsonConverter = jsonConverter;
        this.mongoSchemaManager = new MongoSchemaManager(mongo);
        this.cache = new LatestSnapshotCache(cacheSize, input -> this.getLatest(this.createIdQuery((GlobalId)input)));
    }

    public void persist(Commit commit) {
        this.persistSnapshots(commit);
        this.persistHeadId(commit);
    }

    void clean() {
        this.snapshotsCollection().deleteMany((Bson)new Document());
        this.headCollection().deleteMany((Bson)new Document());
    }

    public List<CdoSnapshot> getStateHistory(GlobalId globalId, QueryParams queryParams) {
        Bson query = queryParams.isAggregate() ? this.createIdQueryWithAggregate(globalId) : this.createIdQuery(globalId);
        return this.queryForSnapshots(query, Optional.of(queryParams));
    }

    public Optional<CdoSnapshot> getLatest(GlobalId globalId) {
        return this.cache.getLatest(globalId);
    }

    public List<CdoSnapshot> getSnapshots(QueryParams queryParams) {
        return this.queryForSnapshots((Bson)new BasicDBObject(), Optional.of(queryParams));
    }

    public List<CdoSnapshot> getSnapshots(Collection<SnapshotIdentifier> snapshotIdentifiers) {
        return snapshotIdentifiers.isEmpty() ? Collections.emptyList() : this.queryForSnapshots(this.createSnapshotIdentifiersQuery(snapshotIdentifiers), Optional.empty());
    }

    public List<CdoSnapshot> getValueObjectStateHistory(EntityType ownerEntity, String path, QueryParams queryParams) {
        BasicDBObject query = new BasicDBObject("globalId.ownerId.entity", (Object)ownerEntity.getName());
        query.append("globalId.fragment", (Object)path);
        return this.queryForSnapshots((Bson)query, Optional.of(queryParams));
    }

    public List<CdoSnapshot> getStateHistory(Set<ManagedType> givenClasses, QueryParams queryParams) {
        Bson query = this.createManagedTypeQuery(givenClasses, queryParams.isAggregate());
        return this.queryForSnapshots(query, Optional.of(queryParams));
    }

    public CommitId getHeadId() {
        Document headId = (Document)this.headCollection().find().first();
        if (headId == null) {
            return null;
        }
        return new MongoHeadId(headId).toCommitId();
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }

    public void ensureSchema() {
        this.mongoSchemaManager.ensureSchema();
    }

    private Bson createIdQuery(GlobalId id) {
        return new BasicDBObject("globalId_key", (Object)id.value());
    }

    private Bson createIdQueryWithAggregate(GlobalId id) {
        return Filters.or((Bson[])new Bson[]{this.createIdQuery(id), MongoRepository.prefixQuery("globalId_key", id.value() + "#")});
    }

    private Bson createVersionQuery(Long version) {
        return new BasicDBObject("version", (Object)version);
    }

    private Bson createSnapshotIdentifiersQuery(Collection<SnapshotIdentifier> snapshotIdentifiers) {
        List descFilters = (List)snapshotIdentifiers.stream().map(snapshotIdentifier -> Filters.and((Bson[])new Bson[]{this.createIdQuery(snapshotIdentifier.getGlobalId()), this.createVersionQuery(snapshotIdentifier.getVersion())})).collect(Lists.toImmutableList());
        return Filters.or((Iterable)descFilters);
    }

    private Bson createManagedTypeQuery(Set<ManagedType> managedTypes, boolean aggregate) {
        List classFilters = (List)managedTypes.stream().map(managedType -> {
            if (managedType instanceof ValueObjectType) {
                return this.createValueObjectTypeQuery((ManagedType)managedType);
            }
            return this.createEntityTypeQuery(aggregate, (ManagedType)managedType);
        }).collect(Lists.toImmutableList());
        return Filters.or((Iterable)classFilters);
    }

    private Bson createValueObjectTypeQuery(ManagedType managedType) {
        return new BasicDBObject("globalId.valueObject", (Object)managedType.getName());
    }

    private Bson createEntityTypeQuery(boolean aggregate, ManagedType managedType) {
        Bson entityTypeQuery = MongoRepository.prefixQuery("globalId_key", managedType.getName() + "/");
        if (!aggregate) {
            entityTypeQuery = Filters.and((Bson[])new Bson[]{entityTypeQuery, Filters.exists((String)"globalId.entity")});
        }
        return entityTypeQuery;
    }

    private CdoSnapshot readFromDBObject(Document dbObject) {
        return (CdoSnapshot)this.jsonConverter.fromJson(DocumentConverter.fromDocument(this.mapKeyDotReplacer.back(dbObject)), CdoSnapshot.class);
    }

    private Document writeToDBObject(CdoSnapshot snapshot) {
        Validate.conditionFulfilled((this.jsonConverter != null ? 1 : 0) != 0, (String)"MongoRepository: jsonConverter is null");
        Document dbObject = DocumentConverter.toDocument((JsonObject)this.jsonConverter.toJsonElement((Object)snapshot));
        dbObject = this.mapKeyDotReplacer.replaceInSnapshotState(dbObject);
        dbObject.append("globalId_key", (Object)snapshot.getGlobalId().value());
        return dbObject;
    }

    private MongoCollection<Document> snapshotsCollection() {
        return this.mongoSchemaManager.snapshotsCollection();
    }

    private MongoCollection<Document> headCollection() {
        return this.mongoSchemaManager.headCollection();
    }

    private void persistSnapshots(Commit commit) {
        MongoCollection<Document> collection = this.snapshotsCollection();
        commit.getSnapshots().forEach(snapshot -> {
            collection.insertOne((Object)this.writeToDBObject((CdoSnapshot)snapshot));
            this.cache.put((CdoSnapshot)snapshot);
        });
    }

    private void persistHeadId(Commit commit) {
        MongoCollection<Document> headIdCollection = this.headCollection();
        Document oldHead = (Document)headIdCollection.find().first();
        MongoHeadId newHeadId = new MongoHeadId(commit.getId());
        if (oldHead == null) {
            headIdCollection.insertOne((Object)newHeadId.toDocument());
        } else {
            headIdCollection.updateOne(this.objectIdFiler(oldHead), (Bson)newHeadId.getUpdateCommand());
        }
    }

    private Bson objectIdFiler(Document document) {
        return Filters.eq((String)"_id", (Object)document.getObjectId((Object)"_id"));
    }

    private MongoCursor<Document> getMongoSnapshotsCursor(Bson query, Optional<QueryParams> queryParams) {
        FindIterable findIterable = this.snapshotsCollection().find(this.applyQueryParams(query, queryParams)).sort((Bson)new Document("commitMetadata.id", (Object)-1));
        return this.applyQueryParams((FindIterable<Document>)findIterable, queryParams).iterator();
    }

    private Bson applyQueryParams(Bson query, Optional<QueryParams> queryParams) {
        if (queryParams.isPresent()) {
            QueryParams params = queryParams.get();
            if (params.from().isPresent()) {
                query = this.addFromDateFiler(query, (LocalDateTime)params.from().get());
            }
            if (params.to().isPresent()) {
                query = this.addToDateFilter(query, (LocalDateTime)params.to().get());
            }
            if (params.toCommitId().isPresent()) {
                query = this.addToCommitIdFilter(query, (CommitId)params.toCommitId().get());
            }
            if (params.commitIds().size() > 0) {
                query = this.addCommitIdFilter(query, params.commitIds());
            }
            if (params.version().isPresent()) {
                query = this.addVersionFilter(query, (Long)params.version().get());
            }
            if (params.author().isPresent()) {
                query = this.addAuthorFilter(query, (String)params.author().get());
            }
            if (!params.commitProperties().isEmpty()) {
                query = this.addCommitPropertiesFilter(query, params.commitProperties());
            }
            if (params.changedProperty().isPresent()) {
                query = this.addChangedPropertyFilter(query, (String)params.changedProperty().get());
            }
        }
        return query;
    }

    private FindIterable<Document> applyQueryParams(FindIterable<Document> findIterable, Optional<QueryParams> queryParams) {
        if (queryParams.isPresent()) {
            QueryParams params = queryParams.get();
            findIterable = findIterable.limit(params.limit()).skip(params.skip());
        }
        return findIterable;
    }

    private Bson addFromDateFiler(Bson query, LocalDateTime from) {
        return Filters.and((Bson[])new Bson[]{query, Filters.gte((String)"commitMetadata.commitDate", (Object)UtilTypeCoreAdapters.serialize((LocalDateTime)from))});
    }

    private Bson addToDateFilter(Bson query, LocalDateTime to) {
        return Filters.and((Bson[])new Bson[]{query, Filters.lte((String)"commitMetadata.commitDate", (Object)UtilTypeCoreAdapters.serialize((LocalDateTime)to))});
    }

    private Bson addToCommitIdFilter(Bson query, CommitId commitId) {
        return Filters.and((Bson[])new Bson[]{query, Filters.lte((String)"commitMetadata.id", (Object)commitId.valueAsNumber().doubleValue())});
    }

    private Bson addCommitIdFilter(Bson query, Set<CommitId> commitIds) {
        return Filters.in((String)"commitMetadata.id", (Iterable)commitIds.stream().map(c -> c.valueAsNumber().doubleValue()).collect(Collectors.toSet()));
    }

    private Bson addChangedPropertyFilter(Bson query, String changedProperty) {
        return Filters.and((Bson[])new Bson[]{query, new BasicDBObject("changedProperties", (Object)changedProperty)});
    }

    private Bson addVersionFilter(Bson query, Long version) {
        return Filters.and((Bson[])new Bson[]{query, this.createVersionQuery(version)});
    }

    private Bson addCommitPropertiesFilter(Bson query, Map<String, String> commitProperties) {
        List propertyFilters = (List)commitProperties.entrySet().stream().map(commitProperty -> new BasicDBObject("commitMetadata.properties", (Object)new BasicDBObject("$elemMatch", (Object)new BasicDBObject("key", commitProperty.getKey()).append("value", commitProperty.getValue())))).collect(Lists.toImmutableList());
        return Filters.and((Bson[])new Bson[]{query, Filters.and((Bson[])propertyFilters.toArray(new Bson[0]))});
    }

    private Bson addAuthorFilter(Bson query, String author) {
        return Filters.and((Bson[])new Bson[]{query, new BasicDBObject("commitMetadata.author", (Object)author)});
    }

    private Optional<CdoSnapshot> getLatest(Bson idQuery) {
        QueryParams queryParams = QueryParamsBuilder.withLimit((int)1).build();
        MongoCursor<Document> mongoLatest = this.getMongoSnapshotsCursor(idQuery, Optional.of(queryParams));
        return MongoRepository.getOne(mongoLatest).map(d -> this.readFromDBObject((Document)d));
    }

    private List<CdoSnapshot> queryForSnapshots(Bson query, Optional<QueryParams> queryParams) {
        ArrayList<CdoSnapshot> snapshots = new ArrayList<CdoSnapshot>();
        try (MongoCursor<Document> mongoSnapshots = this.getMongoSnapshotsCursor(query, queryParams);){
            while (mongoSnapshots.hasNext()) {
                Document dbObject = (Document)mongoSnapshots.next();
                snapshots.add(this.readFromDBObject(dbObject));
            }
            ArrayList<CdoSnapshot> arrayList = snapshots;
            return arrayList;
        }
    }

    private static <T> Optional<T> getOne(MongoCursor<T> mongoCursor) {
        try {
            if (!mongoCursor.hasNext()) {
                Optional optional = Optional.empty();
                return optional;
            }
            Optional<Object> optional = Optional.of(mongoCursor.next());
            return optional;
        }
        finally {
            mongoCursor.close();
        }
    }

    private static Bson prefixQuery(String fieldName, String prefix) {
        return Filters.regex((String)fieldName, (String)("^" + RegexEscape.escape((String)prefix) + ".*"));
    }
}

