/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.data.aspect;

import java.util.Collection;
import java.util.Collections;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.javers.common.collections.Lists;
import org.javers.common.collections.Optional;
import org.javers.core.Javers;
import org.javers.spring.AuthorProvider;
import org.javers.spring.DefaultAuthorProvider;
import org.javers.spring.data.JaversSpringDataAuditable;
import org.javers.spring.data.handler.AuditChangeHandler;
import org.javers.spring.data.handler.OnDeleteAuditChangeHandler;
import org.javers.spring.data.handler.OnSaveAuditChangeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.DefaultRepositoryMetadata;

@Aspect
public class JaversSpringDataRepositoryAspect {
    private static final Logger LOGGER = LoggerFactory.getLogger(JaversSpringDataRepositoryAspect.class);
    private final AuditChangeHandler saveHandler;
    private final AuditChangeHandler deleteHandler;

    public JaversSpringDataRepositoryAspect(Javers javers) {
        this(javers, (AuthorProvider)new DefaultAuthorProvider());
    }

    public JaversSpringDataRepositoryAspect(Javers javers, AuthorProvider authorProvider) {
        this(new OnSaveAuditChangeHandler(javers, authorProvider), new OnDeleteAuditChangeHandler(javers, authorProvider));
    }

    protected JaversSpringDataRepositoryAspect(AuditChangeHandler saveHandler, AuditChangeHandler deleteHandler) {
        this.saveHandler = saveHandler;
        this.deleteHandler = deleteHandler;
    }

    @Around(value="execution(public * delete(..)) && this(org.springframework.data.repository.CrudRepository)")
    public Object onDeleteExecuted(ProceedingJoinPoint pjp) throws Throwable {
        return this.onVersionEvent(pjp, this.deleteHandler);
    }

    @Around(value="execution(public * save(..)) && this(org.springframework.data.repository.CrudRepository)")
    public Object onSaveExecuted(ProceedingJoinPoint pjp) throws Throwable {
        return this.onVersionEvent(pjp, this.saveHandler);
    }

    private Object onVersionEvent(ProceedingJoinPoint pjp, AuditChangeHandler handler) throws Throwable {
        if (this.isVersionedRepository(pjp)) {
            RepositoryMetadata metadata = this.getMetadata(pjp);
            Iterable<Object> domainObjects = this.getDomainObjectsFromMethodArgumentsOfJoinPoint(pjp);
            Object retVal = pjp.proceed();
            this.applyVersionChanges(metadata, domainObjects, handler);
            return retVal;
        }
        return pjp.proceed();
    }

    private RepositoryMetadata getMetadata(ProceedingJoinPoint pjp) {
        Optional<Class> repoClass = this.getRepositoryInterface(pjp);
        if (repoClass.isPresent()) {
            return DefaultRepositoryMetadata.getMetadata((Class)((Class)repoClass.get()));
        }
        throw new IllegalStateException("Cannot determine repository interface");
    }

    private boolean isVersionedRepository(ProceedingJoinPoint pjp) {
        return this.getRepositoryInterface(pjp).isPresent();
    }

    private Optional<Class> getRepositoryInterface(ProceedingJoinPoint pjp) {
        for (Class<?> i : pjp.getTarget().getClass().getInterfaces()) {
            if (!i.isAnnotationPresent(JaversSpringDataAuditable.class) || !CrudRepository.class.isAssignableFrom(i)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    private Iterable<Object> getDomainObjectsFromMethodArgumentsOfJoinPoint(ProceedingJoinPoint pjp) {
        if (pjp.getArgs() != null && pjp.getArgs().length > 0) {
            Object arg = pjp.getArgs()[0];
            if (arg instanceof Collection) {
                return (Collection)arg;
            }
            return Lists.asList((Object[])new Object[]{arg});
        }
        return Collections.EMPTY_LIST;
    }

    private void applyVersionChanges(RepositoryMetadata metadata, Iterable<Object> domainObjects, AuditChangeHandler handler) {
        for (Object domainObject : domainObjects) {
            this.applyVersionChange(metadata, domainObject, handler);
        }
    }

    private void applyVersionChange(RepositoryMetadata metadata, Object domainObject, AuditChangeHandler handler) {
        LOGGER.info("Commit new version " + domainObject.toString());
        handler.handle(metadata, domainObject);
    }
}

