/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.mongodb;

import org.javers.common.validation.Validate;
import org.javers.core.Javers;
import org.javers.core.JaversBuilder;
import org.javers.repository.api.JaversRepository;
import org.javers.repository.mongo.MongoRepository;
import org.javers.spring.mongodb.TransactionalMongoRepository;
import org.springframework.data.mongodb.MongoTransactionManager;

public final class TransactionalMongoJaversBuilder
extends JaversBuilder {
    private MongoRepository mongoRepository;
    private MongoTransactionManager txManager;

    private TransactionalMongoJaversBuilder() {
    }

    public static TransactionalMongoJaversBuilder javers() {
        return new TransactionalMongoJaversBuilder();
    }

    public TransactionalMongoJaversBuilder withTxManager(MongoTransactionManager txManager) {
        this.txManager = txManager;
        return this;
    }

    public TransactionalMongoJaversBuilder registerJaversRepository(JaversRepository mongoRepository) {
        Validate.argumentCheck((boolean)(mongoRepository instanceof MongoRepository), (String)"MongoRepository expected");
        this.mongoRepository = (MongoRepository)mongoRepository;
        return this;
    }

    public Javers build() {
        if (this.txManager != null) {
            logger.info("creating Javers' MongoRepository with multi-document transactions support");
            super.registerJaversRepository((JaversRepository)new TransactionalMongoRepository(this.mongoRepository, this.txManager));
        } else {
            logger.info("creating Javers' MongoRepository without multi-document transactions support, as there is no MongoTransactionManager provided");
            super.registerJaversRepository((JaversRepository)this.mongoRepository);
        }
        Javers javersCore = super.assembleJaversInstance();
        return javersCore;
    }
}

