/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.jpa;

import org.javers.common.exception.JaversException;
import org.javers.common.exception.JaversExceptionCode;
import org.javers.core.Javers;
import org.javers.core.JaversBuilder;
import org.javers.repository.sql.JaversSqlRepository;
import org.javers.spring.jpa.JaversTransactionalDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;

public final class TransactionalJaversBuilder
extends JaversBuilder {
    private static final Logger logger = LoggerFactory.getLogger(TransactionalJaversBuilder.class);
    private PlatformTransactionManager txManager;

    private TransactionalJaversBuilder() {
    }

    public static TransactionalJaversBuilder javers() {
        return new TransactionalJaversBuilder();
    }

    public TransactionalJaversBuilder withTxManager(PlatformTransactionManager txManager) {
        this.txManager = txManager;
        return this;
    }

    public Javers build() {
        if (this.txManager == null) {
            throw new JaversException(JaversExceptionCode.TRANSACTION_MANAGER_NOT_SET, new Object[0]);
        }
        Javers javersCore = super.assembleJaversInstance();
        JaversTransactionalDecorator javersTransactional = new JaversTransactionalDecorator(javersCore, (JaversSqlRepository)this.getContainerComponent(JaversSqlRepository.class), this.txManager);
        logger.info("JaVers transactional decorator is ready");
        return javersTransactional;
    }
}

