/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.auditable.aspect.springdata;

import java.util.Optional;
import org.aspectj.lang.JoinPoint;
import org.javers.core.Javers;
import org.javers.spring.annotation.JaversSpringDataAuditable;
import org.javers.spring.auditable.AspectUtil;
import org.javers.spring.auditable.AuthorProvider;
import org.javers.spring.auditable.CommitPropertiesProvider;
import org.javers.spring.auditable.aspect.springdata.AuditChangeHandler;
import org.javers.spring.auditable.aspect.springdata.OnDeleteAuditChangeHandler;
import org.javers.spring.auditable.aspect.springdata.OnSaveAuditChangeHandler;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.DefaultRepositoryMetadata;

class AbstractSpringAuditableRepositoryAspect {
    private final AuditChangeHandler saveHandler;
    private final AuditChangeHandler deleteHandler;

    AbstractSpringAuditableRepositoryAspect(Javers javers, AuthorProvider authorProvider, CommitPropertiesProvider commitPropertiesProvider) {
        this.saveHandler = new OnSaveAuditChangeHandler(javers, authorProvider, commitPropertiesProvider);
        this.deleteHandler = new OnDeleteAuditChangeHandler(javers, authorProvider, commitPropertiesProvider);
    }

    void onSave(JoinPoint pjp) {
        this.onVersionEvent(pjp, this.saveHandler);
    }

    void onDelete(JoinPoint pjp) {
        this.onVersionEvent(pjp, this.deleteHandler);
    }

    private void onVersionEvent(JoinPoint pjp, AuditChangeHandler handler) {
        Optional<Class> versionedInterface = this.getRepositoryInterface(pjp);
        versionedInterface.ifPresent(versioned -> {
            RepositoryMetadata metadata = this.getMetadata((Class)versioned);
            Iterable<Object> domainObjects = AspectUtil.collectArguments(pjp);
            this.applyVersionChanges(metadata, domainObjects, handler);
        });
    }

    private RepositoryMetadata getMetadata(Class versionedInterface) {
        return DefaultRepositoryMetadata.getMetadata((Class)versionedInterface);
    }

    private Optional<Class> getRepositoryInterface(JoinPoint pjp) {
        for (Class<?> i : pjp.getTarget().getClass().getInterfaces()) {
            if (!i.isAnnotationPresent(JaversSpringDataAuditable.class) || !CrudRepository.class.isAssignableFrom(i)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    private void applyVersionChanges(RepositoryMetadata metadata, Iterable<Object> domainObjects, AuditChangeHandler handler) {
        for (Object domainObject : domainObjects) {
            handler.handle(metadata, domainObject);
        }
    }
}

