/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.auditable.aspect.springdata;

import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.aspectj.lang.JoinPoint;
import org.javers.core.Javers;
import org.javers.repository.jql.GlobalIdDTO;
import org.javers.repository.jql.InstanceIdDTO;
import org.javers.repository.jql.QueryBuilder;
import org.javers.spring.annotation.JaversSpringDataAuditable;
import org.javers.spring.auditable.AspectUtil;
import org.javers.spring.auditable.AuthorProvider;
import org.javers.spring.auditable.CommitPropertiesProvider;
import org.javers.spring.auditable.aspect.springdata.AuditChangeHandler;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.DefaultRepositoryMetadata;

public class AbstractSpringAuditableRepositoryAspect {
    private final AuditChangeHandler saveHandler;
    private final AuditChangeHandler deleteHandler;
    private final Javers javers;
    private final AuthorProvider authorProvider;
    private final CommitPropertiesProvider commitPropertiesProvider;

    protected AbstractSpringAuditableRepositoryAspect(Javers javers, AuthorProvider authorProvider, CommitPropertiesProvider commitPropertiesProvider) {
        this.javers = javers;
        this.authorProvider = authorProvider;
        this.commitPropertiesProvider = commitPropertiesProvider;
        this.saveHandler = (repositoryMetadata, domainObject) -> javers.commit(authorProvider.provide(), domainObject, commitPropertiesProvider.provide());
        this.deleteHandler = new OnDeleteAuditChangeHandler();
    }

    protected void onSave(JoinPoint pjp, Object returnedObject) {
        this.onVersionEvent(pjp, this.saveHandler, () -> AspectUtil.collectReturnedObjects(returnedObject));
    }

    protected void onDelete(JoinPoint pjp) {
        this.onVersionEvent(pjp, this.deleteHandler, () -> AspectUtil.collectArguments(pjp));
    }

    private void onVersionEvent(JoinPoint pjp, AuditChangeHandler changeHandler, Supplier<Iterable<Object>> domainObjectsExtractor) {
        Optional<Class> versionedInterface = this.getRepositoryInterface(pjp);
        versionedInterface.ifPresent(versioned -> {
            RepositoryMetadata metadata = this.getMetadata((Class)versioned);
            Iterable domainObjects = (Iterable)domainObjectsExtractor.get();
            for (Object domainObject : domainObjects) {
                changeHandler.handle(metadata, domainObject);
            }
        });
    }

    private RepositoryMetadata getMetadata(Class versionedInterface) {
        return DefaultRepositoryMetadata.getMetadata((Class)versionedInterface);
    }

    private Optional<Class> getRepositoryInterface(JoinPoint pjp) {
        for (Class<?> i : pjp.getTarget().getClass().getInterfaces()) {
            if (!i.isAnnotationPresent(JaversSpringDataAuditable.class) || !CrudRepository.class.isAssignableFrom(i)) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    private class OnDeleteAuditChangeHandler
    implements AuditChangeHandler {
        private OnDeleteAuditChangeHandler() {
        }

        @Override
        public void handle(RepositoryMetadata repositoryMetadata, Object domainObjectOrId) {
            Map<String, String> props = AbstractSpringAuditableRepositoryAspect.this.commitPropertiesProvider.provide();
            String author = AbstractSpringAuditableRepositoryAspect.this.authorProvider.provide();
            if (this.isIdClass(repositoryMetadata, domainObjectOrId)) {
                if (AbstractSpringAuditableRepositoryAspect.this.javers.findSnapshots(QueryBuilder.byInstanceId((Object)domainObjectOrId, (Class)repositoryMetadata.getDomainType()).build()).size() == 0) {
                    return;
                }
                AbstractSpringAuditableRepositoryAspect.this.javers.commitShallowDeleteById(author, (GlobalIdDTO)InstanceIdDTO.instanceId((Object)domainObjectOrId, (Class)repositoryMetadata.getDomainType()), props);
            } else if (this.isDomainClass(repositoryMetadata, domainObjectOrId)) {
                if (AbstractSpringAuditableRepositoryAspect.this.javers.findSnapshots(QueryBuilder.byInstance((Object)domainObjectOrId).build()).size() == 0) {
                    return;
                }
                AbstractSpringAuditableRepositoryAspect.this.javers.commitShallowDelete(author, domainObjectOrId, props);
            } else {
                throw new IllegalArgumentException("Domain object or object id expected");
            }
        }

        private boolean isDomainClass(RepositoryMetadata metadata, Object o) {
            return metadata.getDomainType().isAssignableFrom(o.getClass());
        }

        private boolean isIdClass(RepositoryMetadata metadata, Object o) {
            return metadata.getIdType().isAssignableFrom(o.getClass());
        }
    }
}

