/*
 * Decompiled with CFR 0.152.
 */
package org.javers.spring.auditable.aspect;

import java.util.Map;
import org.aspectj.lang.JoinPoint;
import org.javers.core.Javers;
import org.javers.core.commit.Commit;
import org.javers.spring.auditable.AspectUtil;
import org.javers.spring.auditable.AuthorProvider;
import org.javers.spring.auditable.CommitPropertiesProvider;

class JaversCommitAdvice {
    private final Javers javers;
    private final AuthorProvider authorProvider;
    private final CommitPropertiesProvider commitPropertiesProvider;

    JaversCommitAdvice(Javers javers, AuthorProvider authorProvider, CommitPropertiesProvider commitPropertiesProvider) {
        this.javers = javers;
        this.authorProvider = authorProvider;
        this.commitPropertiesProvider = commitPropertiesProvider;
    }

    void commitSaveMethodArguments(JoinPoint pjp) {
        this.commitMethodArguments(pjp, (arg_0, arg_1, arg_2) -> ((Javers)this.javers).commit(arg_0, arg_1, arg_2));
    }

    void commitDeleteMethodArguments(JoinPoint pjp) {
        this.commitMethodArguments(pjp, (arg_0, arg_1, arg_2) -> ((Javers)this.javers).commitShallowDelete(arg_0, arg_1, arg_2));
    }

    private void commitMethodArguments(JoinPoint pjp, JaversCommitHandler commitHandler) {
        String author = this.authorProvider.provide();
        Map<String, String> props = this.commitPropertiesProvider.provide();
        for (Object arg : AspectUtil.collectArguments(pjp)) {
            commitHandler.commit(author, arg, props);
        }
    }

    @FunctionalInterface
    private static interface JaversCommitHandler {
        public Commit commit(String var1, Object var2, Map<String, String> var3);
    }
}

