/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.json;

import com.google.common.collect.ImmutableMap;
import java.math.BigDecimal;
import java.util.Map;
import org.javersion.core.Persistent;

public enum JsonType {
    OBJECT,
    ARRAY,
    NUMBER,
    BOOLEAN,
    STRING,
    NULL;

    private static final Map<Class<?>, JsonType> PERSISTENT_TO_JSON_TYPE;

    public static JsonType getType(Object value) {
        if (value == null) {
            return NULL;
        }
        return PERSISTENT_TO_JSON_TYPE.get(value.getClass());
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put(Persistent.Object.class, (Object)OBJECT);
        builder.put(Persistent.Array.class, (Object)ARRAY);
        builder.put(String.class, (Object)STRING);
        builder.put(Boolean.class, (Object)BOOLEAN);
        builder.put(Long.class, (Object)NUMBER);
        builder.put(Double.class, (Object)NUMBER);
        builder.put(BigDecimal.class, (Object)NUMBER);
        PERSISTENT_TO_JSON_TYPE = builder.build();
    }
}

