/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.json;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import org.javersion.core.Persistent;
import org.javersion.json.JsonType;
import org.javersion.path.NodeId;
import org.javersion.path.PropertyPath;
import org.javersion.path.PropertyTree;
import org.javersion.path.Schema;

public class JsonSerializer {
    public static final String TYPE_FIELD = "_type";
    public static final String META_PREFIX = "_";
    private final Schema<?> schemaRoot;
    private final Config config;

    public JsonSerializer() {
        this(null);
    }

    public JsonSerializer(Schema<Persistent.Type> schemaRoot) {
        this(new Config(), schemaRoot);
    }

    public JsonSerializer(Config config, Schema<?> schemaRoot) {
        this.config = config;
        this.schemaRoot = schemaRoot;
    }

    public JsonPaths parse(String json) {
        JsonPaths paths = new JsonPaths();
        try (JsonReader jsonReader = this.newJsonReader(json);){
            this.toMap((PropertyPath)PropertyPath.ROOT, jsonReader, paths.meta, paths.properties);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return paths;
    }

    private JsonReader newJsonReader(String json) {
        JsonReader reader = new JsonReader((Reader)new StringReader(json));
        reader.setLenient(this.config.lenient);
        return reader;
    }

    public String serialize(Map<PropertyPath, Object> map) {
        PropertyTree tree = PropertyTree.build(map.keySet());
        StringWriter stringWriter = new StringWriter();
        try (JsonWriter jsonWriter = this.newJsonWriter(stringWriter);){
            this.toJson(tree, map, jsonWriter);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stringWriter.toString();
    }

    private JsonWriter newJsonWriter(StringWriter stringWriter) {
        JsonWriter writer = new JsonWriter((Writer)stringWriter);
        writer.setIndent(this.config.indent);
        writer.setLenient(this.config.lenient);
        writer.setSerializeNulls(this.config.serializeNulls);
        return writer;
    }

    private void toJson(PropertyTree tree, Map<PropertyPath, Object> map, JsonWriter writer) throws IOException {
        Object value = map.get(tree.path);
        switch (JsonType.getType(value)) {
            case NULL: {
                writer.nullValue();
                break;
            }
            case STRING: {
                writer.value((String)value);
                break;
            }
            case BOOLEAN: {
                writer.value(((Boolean)value).booleanValue());
                break;
            }
            case NUMBER: {
                writer.value((Number)value);
                break;
            }
            case ARRAY: {
                writer.beginArray();
                SortedMap childrenMap = tree.getChildrenMap();
                int nonNullElements = 0;
                int i = 0;
                while (nonNullElements < childrenMap.size()) {
                    PropertyTree child = (PropertyTree)childrenMap.get(NodeId.valueOf((long)i));
                    if (child != null) {
                        ++nonNullElements;
                        this.toJson(child, map, writer);
                    } else {
                        writer.nullValue();
                    }
                    ++i;
                }
                writer.endArray();
                break;
            }
            case OBJECT: {
                writer.beginObject();
                String typeAlias = ((Persistent.Object)value).type;
                if (!"Map".equals(typeAlias)) {
                    writer.name(TYPE_FIELD).value(typeAlias);
                }
                for (PropertyTree child : tree.getChildren()) {
                    NodeId nodeId = child.getNodeId();
                    writer.name(nodeId.toString());
                    this.toJson(child, map, writer);
                }
                writer.endObject();
            }
        }
    }

    private void toMap(PropertyPath path, JsonReader reader, Map<PropertyPath, Object> meta, Map<PropertyPath, Object> properties) throws IOException {
        switch (reader.peek()) {
            case BEGIN_OBJECT: {
                reader.beginObject();
                boolean map = this.isMap(path);
                while (reader.hasNext()) {
                    String property = reader.nextName();
                    Object propertyPath = map ? path.key(property) : path.propertyOrKey(property);
                    if (property.startsWith(META_PREFIX)) {
                        this.toMap((PropertyPath)propertyPath, reader, meta, meta);
                        continue;
                    }
                    this.toMap((PropertyPath)propertyPath, reader, meta, properties);
                }
                String type = this.getType(path, meta);
                properties.put(path, Persistent.object((String)type));
                reader.endObject();
                break;
            }
            case BEGIN_ARRAY: {
                properties.put(path, Persistent.array());
                reader.beginArray();
                int i = 0;
                while (reader.hasNext()) {
                    this.toMap((PropertyPath)path.index((long)i++), reader, meta, properties);
                }
                reader.endArray();
                break;
            }
            case STRING: {
                properties.put(path, reader.nextString());
                break;
            }
            case NUMBER: {
                properties.put(path, new BigDecimal(reader.nextString()));
                break;
            }
            case BOOLEAN: {
                properties.put(path, reader.nextBoolean());
                break;
            }
            case NULL: {
                reader.nextNull();
                properties.put(path, null);
            }
        }
    }

    private boolean isMap(PropertyPath path) {
        if (this.schemaRoot != null) {
            Schema schema = (Schema)this.schemaRoot.find(path);
            return schema != null && schema.hasChild(NodeId.ANY_KEY) || schema.hasChild(NodeId.ANY);
        }
        return false;
    }

    private String getType(PropertyPath path, Map<PropertyPath, Object> meta) {
        Object typeObject = meta.get(path.property(TYPE_FIELD));
        if (typeObject != null) {
            return typeObject.toString();
        }
        return "Map";
    }

    public static class Config {
        public boolean serializeNulls = true;
        public boolean lenient = false;
        public String indent = "";

        public Config() {
        }

        public Config(boolean serializeNulls, boolean lenient, String indent) {
            this.serializeNulls = serializeNulls;
            this.lenient = lenient;
            this.indent = indent;
        }
    }

    public static class JsonPaths {
        public Map<PropertyPath, Object> meta = new LinkedHashMap<PropertyPath, Object>();
        public Map<PropertyPath, Object> properties = new LinkedHashMap<PropertyPath, Object>();
    }
}

