/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.path;

import org.apache.commons.lang3.StringEscapeUtils;
import org.javersion.path.PropertyPath;
import org.javersion.util.Check;

public abstract class NodeId
implements Comparable<NodeId> {
    public static final NodeId ROOT_ID = new SpecialNodeId("", 1, null){

        @Override
        public PropertyPath toPath(PropertyPath parent) {
            return parent;
        }
    };
    public static final NodeId ANY = new SpecialNodeId("*", 2, null){

        @Override
        public PropertyPath toPath(PropertyPath parent) {
            return new PropertyPath.Any(parent);
        }
    };
    public static final NodeId ANY_INDEX = new SpecialNodeId("[]", 3, ANY){

        @Override
        public PropertyPath toPath(PropertyPath parent) {
            return new PropertyPath.AnyIndex(parent);
        }
    };
    public static final NodeId ANY_KEY = new SpecialNodeId("{}", 5, ANY){

        @Override
        public PropertyPath toPath(PropertyPath parent) {
            return new PropertyPath.AnyKey(parent);
        }
    };
    public static final NodeId ANY_PROPERTY = new SpecialNodeId(".*", 4, ANY_KEY){

        @Override
        public PropertyPath toPath(PropertyPath parent) {
            return new PropertyPath.AnyProperty(parent);
        }
    };
    private static final IndexId[] INDEXES = new IndexId[32];

    public static NodeId index(Number number) {
        return NodeId.index(number.longValue());
    }

    public static IndexId index(long index) {
        if (index >= 0L && index < (long)INDEXES.length) {
            return INDEXES[(int)index];
        }
        return new IndexId(index);
    }

    public static KeyId key(String key) {
        return new KeyId(key);
    }

    public static PropertyId property(String property) {
        return new PropertyId(property);
    }

    public static NodeId keyOrIndex(Object object) {
        if (object instanceof Number) {
            return NodeId.index((Number)object);
        }
        if (object instanceof String) {
            return NodeId.key((String)object);
        }
        throw new IllegalArgumentException("Unsupported NodeId type: " + object);
    }

    NodeId() {
    }

    public boolean isIndex() {
        return false;
    }

    public boolean isKey() {
        return false;
    }

    public long getIndex() {
        throw new UnsupportedOperationException();
    }

    public String getKey() {
        throw new UnsupportedOperationException();
    }

    public Object getKeyOrIndex() {
        if (this.isIndex()) {
            return this.getIndex();
        }
        return this.getKey();
    }

    public abstract NodeId fallbackId();

    protected abstract int getTypeOrdinal();

    public abstract PropertyPath toPath(PropertyPath var1);

    static {
        for (int i = 0; i < INDEXES.length; ++i) {
            NodeId.INDEXES[i] = new IndexId(i);
        }
    }

    private static abstract class SpecialNodeId
    extends NodeId {
        private final String str;
        private final int ordinal;
        private final NodeId fallback;

        private SpecialNodeId(String str, int ordinal, NodeId fallback) {
            this.str = str;
            this.ordinal = ordinal;
            this.fallback = fallback;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof SpecialNodeId && ((SpecialNodeId)obj).str.equals(this.str);
        }

        public int hashCode() {
            return this.str.hashCode();
        }

        public String toString() {
            return this.str;
        }

        @Override
        public NodeId fallbackId() {
            return this.fallback;
        }

        @Override
        protected int getTypeOrdinal() {
            return 1;
        }

        @Override
        public int compareTo(NodeId nodeId) {
            return nodeId instanceof SpecialNodeId ? Integer.compare(this.ordinal, ((SpecialNodeId)nodeId).ordinal) : Integer.compare(this.getTypeOrdinal(), nodeId.getTypeOrdinal());
        }
    }

    public static final class KeyId
    extends KeyBasedId {
        public final String key;

        KeyId(String key) {
            super(key);
            this.key = key;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof KeyId && ((KeyId)obj).key.equals(this.key);
        }

        public final int hashCode() {
            return 17 * this.key.hashCode();
        }

        @Override
        public final int compareTo(NodeId nodeId) {
            return nodeId instanceof KeyId ? this.key.compareTo(((KeyId)nodeId).key) : Integer.compare(this.getTypeOrdinal(), nodeId.getTypeOrdinal());
        }

        @Override
        public NodeId fallbackId() {
            return ANY_KEY;
        }

        @Override
        protected final int getTypeOrdinal() {
            return 4;
        }

        @Override
        public PropertyPath toPath(PropertyPath parent) {
            return new PropertyPath.Key(parent, this);
        }

        public String toString() {
            return new StringBuilder(this.key.length() + 5).append('\"').append(StringEscapeUtils.escapeEcmaScript((String)this.key)).append('\"').toString();
        }
    }

    public static final class PropertyId
    extends KeyBasedId {
        PropertyId(String key) {
            super(key);
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof PropertyId && ((PropertyId)obj).key.equals(this.key);
        }

        public final int hashCode() {
            return this.key.hashCode();
        }

        @Override
        public final int compareTo(NodeId nodeId) {
            return nodeId instanceof PropertyId ? this.key.compareTo(((PropertyId)nodeId).key) : Integer.compare(this.getTypeOrdinal(), nodeId.getTypeOrdinal());
        }

        @Override
        public NodeId fallbackId() {
            return ANY_PROPERTY;
        }

        @Override
        protected final int getTypeOrdinal() {
            return 3;
        }

        @Override
        public PropertyPath toPath(PropertyPath parent) {
            return new PropertyPath.Property(parent, this);
        }

        public String toString() {
            return this.key;
        }
    }

    private static abstract class KeyBasedId
    extends NodeId {
        public final String key;

        KeyBasedId(String key) {
            Check.notNull((Object)key, (String)"key");
            this.key = key;
        }

        @Override
        public final boolean isKey() {
            return true;
        }

        @Override
        public final String getKey() {
            return this.key;
        }
    }

    public static final class IndexId
    extends NodeId {
        public final long index;

        IndexId(long index) {
            this.index = index;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof IndexId) {
                return ((IndexId)obj).index == this.index;
            }
            return false;
        }

        public int hashCode() {
            return Long.hashCode(this.index);
        }

        @Override
        public boolean isIndex() {
            return true;
        }

        @Override
        public long getIndex() {
            return this.index;
        }

        public String toString() {
            return Long.toString(this.index);
        }

        @Override
        public NodeId fallbackId() {
            return ANY_INDEX;
        }

        @Override
        protected int getTypeOrdinal() {
            return 2;
        }

        @Override
        public PropertyPath toPath(PropertyPath parent) {
            return new PropertyPath.Index(parent, this);
        }

        @Override
        public int compareTo(NodeId nodeId) {
            return nodeId instanceof IndexId ? Long.compare(this.index, ((IndexId)nodeId).index) : Integer.compare(this.getTypeOrdinal(), nodeId.getTypeOrdinal());
        }
    }
}

