/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.path;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.javersion.path.NodeId;
import org.javersion.path.PropertyPath;

public class PropertyTree {
    public final PropertyPath path;
    private SortedMap<NodeId, PropertyTree> children = new TreeMap<NodeId, PropertyTree>();

    public static PropertyTree build(PropertyPath ... paths) {
        return PropertyTree.build(Arrays.asList(paths));
    }

    public static PropertyTree build(Collection<PropertyPath> paths) {
        HashMap nodes = Maps.newHashMapWithExpectedSize((int)paths.size());
        for (PropertyPath path : paths) {
            PropertyTree parentTree = PropertyTree.getOrCreate(PropertyPath.ROOT, nodes);
            for (PropertyPath propertyPath : path.asList()) {
                PropertyTree childTree = PropertyTree.getOrCreate(propertyPath, nodes);
                parentTree.children.put(propertyPath.getNodeId(), childTree);
                parentTree = childTree;
            }
        }
        return (PropertyTree)nodes.get(PropertyPath.ROOT);
    }

    private static PropertyTree getOrCreate(PropertyPath path, Map<PropertyPath, PropertyTree> nodes) {
        PropertyTree childTree = nodes.get(path);
        if (childTree == null) {
            childTree = new PropertyTree(path);
            nodes.put(path, childTree);
        }
        return childTree;
    }

    private PropertyTree(PropertyPath path) {
        this.path = path;
    }

    public NodeId getNodeId() {
        return this.path.getNodeId();
    }

    public Collection<PropertyTree> getChildren() {
        return Collections.unmodifiableCollection(this.children.values());
    }

    public SortedMap<NodeId, PropertyTree> getChildrenMap() {
        return Collections.unmodifiableSortedMap(this.children);
    }

    public PropertyTree get(NodeId childNode) {
        return (PropertyTree)this.children.get(childNode);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public PropertyTree get(PropertyPath path) {
        PropertyTree match = this;
        for (PropertyPath propertyPath : path.asList()) {
            if ((match = match.get(propertyPath.getNodeId())) != null) continue;
            throw new IllegalArgumentException("path not found: " + path);
        }
        return match;
    }

    public String toString() {
        return this.path.toString();
    }
}

