/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.path;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.NotNull;
import org.antlr.v4.runtime.tree.RuleNode;
import org.apache.commons.lang3.StringEscapeUtils;
import org.javersion.path.parser.PropertyPathBaseVisitor;
import org.javersion.path.parser.PropertyPathLexer;
import org.javersion.path.parser.PropertyPathParser;

public abstract class PropertyPath
implements Iterable<SubPath> {
    private static final ANTLRErrorListener BASIC_ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            throw new IllegalArgumentException("line " + line + ":" + charPositionInLine + " " + msg);
        }
    };
    private static final ANTLRErrorListener SILENT_ERROR_LISTENER = new BaseErrorListener(){

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            throw new SilentParseException();
        }
    };
    private static final String EMPTY_STRING = "";
    public static final Root ROOT = Root.access$400();
    private volatile transient List<SubPath> fullPath;

    public static PropertyPath parse(String path) {
        Preconditions.checkNotNull((Object)path);
        if (path.length() == 0) {
            return ROOT;
        }
        return PropertyPath.newParser(path, false).parsePath().accept(new PropertyPathBaseVisitor<PropertyPath>(){
            private PropertyPath parent = ROOT;

            @Override
            public PropertyPath visitIndex(PropertyPathParser.IndexContext ctx) {
                this.parent = new Index(this.parent, Integer.parseInt(ctx.getText()));
                return this.parent;
            }

            @Override
            public PropertyPath visitKey(PropertyPathParser.KeyContext ctx) {
                String keyLiteral = ctx.getText();
                this.parent = new Key(this.parent, StringEscapeUtils.unescapeEcmaScript((String)keyLiteral.substring(1, keyLiteral.length() - 1)));
                return this.parent;
            }

            @Override
            public PropertyPath visitProperty(PropertyPathParser.PropertyContext ctx) {
                this.parent = new Property(this.parent, ctx.getText());
                return this.parent;
            }

            @Override
            public PropertyPath visitAnyProperty(@NotNull PropertyPathParser.AnyPropertyContext ctx) {
                this.parent = new AnyProperty(this.parent);
                return this.parent;
            }

            @Override
            public PropertyPath visitAnyIndex(PropertyPathParser.AnyIndexContext ctx) {
                this.parent = new AnyIndex(this.parent);
                return this.parent;
            }

            @Override
            public PropertyPath visitAnyKey(PropertyPathParser.AnyKeyContext ctx) {
                this.parent = new AnyKey(this.parent);
                return this.parent;
            }

            @Override
            public PropertyPath visitAny(PropertyPathParser.AnyContext ctx) {
                this.parent = new Any(this.parent);
                return this.parent;
            }

            protected PropertyPath defaultResult() {
                return this.parent;
            }
        });
    }

    PropertyPath() {
    }

    public Property property(String name) {
        return PropertyPath.newParser(name, false).parseProperty().accept(new PropertyPathBaseVisitor<Property>(){

            @Override
            public Property visitProperty(PropertyPathParser.PropertyContext ctx) {
                return new Property(PropertyPath.this, ctx.getText());
            }

            protected boolean shouldVisitNextChild(RuleNode node, Property currentResult) {
                return currentResult == null;
            }
        });
    }

    public final Index index(long index) {
        Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0, (Object)"index should be >= 0");
        return new Index(this, index);
    }

    public final Key key(String index) {
        Preconditions.checkNotNull((Object)index);
        return new Key(this, index);
    }

    public final SubPath keyOrIndex(Object object) {
        return this.keyOrIndex(NodeId.valueOf(object));
    }

    public final SubPath keyOrIndex(NodeId nodeId) {
        Preconditions.checkNotNull((Object)nodeId);
        if (nodeId.isKey()) {
            return new Key(this, nodeId);
        }
        if (nodeId.isIndex()) {
            return new Index(this, nodeId);
        }
        throw new IllegalArgumentException("Expected KeyId or IndexId, got " + nodeId.getClass());
    }

    public final AnyProperty anyProperty() {
        return new AnyProperty(this);
    }

    public final AnyIndex anyIndex() {
        return new AnyIndex(this);
    }

    public final AnyKey anyKey() {
        return new AnyKey(this);
    }

    public final Any any() {
        return new Any(this);
    }

    public final SubPath propertyOrKey(String string) {
        Preconditions.checkNotNull((Object)string);
        try {
            return PropertyPath.newParser(string, true).parseProperty().accept(new PropertyPathBaseVisitor<SubPath>(){

                @Override
                public SubPath visitProperty(PropertyPathParser.PropertyContext ctx) {
                    return new Property(PropertyPath.this, ctx.getText());
                }

                protected boolean shouldVisitNextChild(RuleNode node, SubPath currentResult) {
                    return currentResult == null;
                }
            });
        }
        catch (SilentParseException e) {
            return new Key(this, string);
        }
    }

    public final PropertyPath path(PropertyPath path) {
        PropertyPath result = this;
        for (SubPath subPath : path) {
            result = subPath.withParent(result);
        }
        return result;
    }

    @Override
    public Iterator<SubPath> iterator() {
        return this.asList().iterator();
    }

    public List<SubPath> asList() {
        return this.fullPath != null ? this.fullPath : (this.fullPath = this.getFullPath());
    }

    public boolean isRoot() {
        return false;
    }

    public boolean startsWith(PropertyPath other) {
        if (other.isRoot()) {
            return true;
        }
        if (this.isRoot()) {
            return false;
        }
        List<SubPath> otherPath = other.asList();
        List<SubPath> thisPath = this.asList();
        int otherSize = otherPath.size();
        return thisPath.size() >= otherSize && thisPath.get(otherSize - 1).equals(otherPath.get(otherSize - 1));
    }

    public PropertyPath toSchemaPath() {
        PropertyPath schemaPath = ROOT;
        for (SubPath path : this) {
            schemaPath = path.toSchemaPath(schemaPath);
        }
        return schemaPath;
    }

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract NodeId getNodeId();

    abstract List<SubPath> getFullPath();

    abstract PropertyPath withParent(PropertyPath var1);

    private static PropertyPathParser newParser(String input, boolean silent) {
        PropertyPathLexer lexer = new PropertyPathLexer((CharStream)new ANTLRInputStream(input));
        lexer.removeErrorListeners();
        lexer.addErrorListener(silent ? SILENT_ERROR_LISTENER : BASIC_ERROR_LISTENER);
        PropertyPathParser parser = new PropertyPathParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        parser.removeErrorListeners();
        parser.addErrorListener(silent ? SILENT_ERROR_LISTENER : BASIC_ERROR_LISTENER);
        return parser;
    }

    public static final class Any
    extends SubPath {
        private Any(PropertyPath parent) {
            super(parent, NodeId.ANY);
        }

        @Override
        Any withParent(PropertyPath newParent) {
            return newParent.equals(this.parent) ? this : new Any(newParent);
        }

        @Override
        protected void appendNode(StringBuilder sb) {
            sb.append(NodeId.ANY);
        }
    }

    public static final class AnyKey
    extends SubPath {
        private AnyKey(PropertyPath parent) {
            super(parent, NodeId.ANY_KEY);
        }

        @Override
        AnyKey withParent(PropertyPath newParent) {
            return newParent.equals(this.parent) ? this : new AnyKey(newParent);
        }

        @Override
        protected void appendNode(StringBuilder sb) {
            sb.append(NodeId.ANY_KEY);
        }
    }

    public static final class AnyIndex
    extends SubPath {
        private AnyIndex(PropertyPath parent) {
            super(parent, NodeId.ANY_INDEX);
        }

        @Override
        AnyIndex withParent(PropertyPath newParent) {
            return newParent.equals(this.parent) ? this : new AnyIndex(newParent);
        }

        @Override
        protected void appendNode(StringBuilder sb) {
            sb.append(NodeId.ANY_INDEX);
        }
    }

    public static final class AnyProperty
    extends SubPath {
        private AnyProperty(PropertyPath parent) {
            super(parent, NodeId.ANY_PROPERTY);
        }

        @Override
        AnyProperty withParent(PropertyPath newParent) {
            return newParent.equals(this.parent) ? this : new AnyProperty(newParent);
        }

        @Override
        protected void appendNode(StringBuilder sb) {
            sb.append(NodeId.ANY_PROPERTY);
        }
    }

    public static final class Key
    extends SubPath {
        private Key(PropertyPath parent, String key) {
            super(parent, new KeyId(key));
        }

        private Key(PropertyPath parent, NodeId id) {
            super(parent, id);
        }

        @Override
        AnyKey toSchemaPath(PropertyPath newParent) {
            return new AnyKey(newParent);
        }

        @Override
        SubPath withParent(PropertyPath newParent) {
            return new Key(newParent, this.nodeId);
        }

        @Override
        protected void appendNode(StringBuilder sb) {
            sb.append("[\"").append(StringEscapeUtils.escapeEcmaScript((String)this.nodeId.getKey())).append("\"]").toString();
        }
    }

    public static final class Index
    extends SubPath {
        private Index(PropertyPath parent, long index) {
            super(parent, new IndexId(index));
        }

        private Index(PropertyPath parent, NodeId id) {
            super(parent, id);
        }

        @Override
        AnyIndex toSchemaPath(PropertyPath newParent) {
            return new AnyIndex(newParent);
        }

        @Override
        Index withParent(PropertyPath newParent) {
            return new Index(newParent, this.nodeId);
        }

        @Override
        protected void appendNode(StringBuilder sb) {
            sb.append('[').append(this.nodeId.getIndex()).append(']');
        }
    }

    public static final class Property
    extends SubPath {
        private Property(PropertyPath parent, String name) {
            super(parent, new KeyId(name));
        }

        private Property(PropertyPath parent, NodeId nodeId) {
            super(parent, nodeId);
        }

        @Override
        Property toSchemaPath(PropertyPath newParent) {
            return this.withParent(newParent);
        }

        @Override
        Property withParent(PropertyPath newParent) {
            return newParent.equals(this.parent) ? this : new Property(newParent, this.nodeId);
        }

        @Override
        protected void appendNode(StringBuilder sb) {
            if (!this.parent.isRoot()) {
                sb.append('.');
            }
            sb.append(this.nodeId);
        }
    }

    public static abstract class SubPath
    extends PropertyPath {
        public final NodeId nodeId;
        public final PropertyPath parent;

        private SubPath(PropertyPath parent, NodeId nodeId) {
            this.parent = (PropertyPath)Preconditions.checkNotNull((Object)parent, (Object)"parent");
            this.nodeId = (NodeId)Preconditions.checkNotNull((Object)nodeId, (Object)"nodeId");
        }

        @Override
        List<SubPath> getFullPath() {
            List<SubPath> parentPath = this.parent.getFullPath();
            ImmutableList.Builder pathBuilder = ImmutableList.builder();
            pathBuilder.addAll(parentPath);
            pathBuilder.add((Object)this);
            return pathBuilder.build();
        }

        @Override
        public final boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof SubPath) {
                SubPath other = (SubPath)obj;
                return this.nodeId.equals(other.nodeId) && this.parent.equals(other.parent);
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return 31 * this.parent.hashCode() + this.nodeId.hashCode();
        }

        @Override
        public final NodeId getNodeId() {
            return this.nodeId;
        }

        @Override
        public final String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.parent.toString());
            this.appendNode(sb);
            return sb.toString();
        }

        PropertyPath toSchemaPath(PropertyPath newParent) {
            return this.withParent(newParent);
        }

        protected abstract void appendNode(StringBuilder var1);
    }

    public static final class Root
    extends PropertyPath {
        public static final NodeId ID = new SpecialNodeId("");
        private static final Root ROOT = new Root();
        private static final List<SubPath> FULL_PATH = ImmutableList.of();

        private Root() {
        }

        @Override
        List<SubPath> getFullPath() {
            return FULL_PATH;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this;
        }

        @Override
        public String toString() {
            return PropertyPath.EMPTY_STRING;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean isRoot() {
            return true;
        }

        @Override
        public NodeId getNodeId() {
            return ID;
        }

        @Override
        PropertyPath withParent(PropertyPath newParent) {
            return newParent;
        }

        static /* synthetic */ Root access$400() {
            return ROOT;
        }
    }

    private static final class SilentParseException
    extends RuntimeException {
        public SilentParseException() {
            super(null, null, false, false);
        }
    }

    private static class SpecialNodeId
    extends NodeId {
        private final String str;

        private SpecialNodeId(String str) {
            this.str = str;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof SpecialNodeId) {
                return ((SpecialNodeId)obj).str.equals(this.str);
            }
            return false;
        }

        public int hashCode() {
            return this.str.hashCode();
        }

        public String toString() {
            return this.str;
        }

        @Override
        public NodeId fallbackId() {
            return ANY;
        }
    }

    public static final class KeyId
    extends NodeId {
        public final String key;

        private KeyId(String key) {
            Preconditions.checkNotNull((Object)key);
            this.key = key;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof KeyId) {
                return ((KeyId)obj).key.equals(this.key);
            }
            return false;
        }

        @Override
        public boolean isKey() {
            return true;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return this.key;
        }

        @Override
        public NodeId fallbackId() {
            return ANY_KEY;
        }
    }

    public static final class IndexId
    extends NodeId {
        public final long index;

        private IndexId(long index) {
            Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0, (Object)"index should be >= 0");
            this.index = index;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof IndexId) {
                return ((IndexId)obj).index == this.index;
            }
            return false;
        }

        @Override
        public boolean isIndex() {
            return true;
        }

        @Override
        public long getIndex() {
            return this.index;
        }

        public int hashCode() {
            return Long.hashCode(this.index);
        }

        public String toString() {
            return Long.toString(this.index);
        }

        @Override
        public NodeId fallbackId() {
            return ANY_INDEX;
        }
    }

    public static abstract class NodeId {
        public static final NodeId ANY = new SpecialNodeId("*"){

            @Override
            public NodeId fallbackId() {
                return null;
            }
        };
        public static final NodeId ANY_PROPERTY = new SpecialNodeId(".*");
        public static final NodeId ANY_INDEX = new SpecialNodeId("[]");
        public static final NodeId ANY_KEY = new SpecialNodeId("{}");
        private static final IndexId[] INDEXES = new IndexId[32];

        public static IndexId valueOf(long index) {
            Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0, (Object)"index should be >= 0");
            if (index < (long)INDEXES.length) {
                return INDEXES[(int)index];
            }
            return new IndexId(index);
        }

        public static KeyId valueOf(String key) {
            return new KeyId(key);
        }

        public static NodeId valueOf(Object object) {
            if (object instanceof Number) {
                return NodeId.valueOf(((Number)object).longValue());
            }
            if (object instanceof String) {
                return NodeId.valueOf((String)object);
            }
            throw new IllegalArgumentException("Unsupported NodeId type: " + object);
        }

        private NodeId() {
        }

        public boolean isIndex() {
            return false;
        }

        public boolean isKey() {
            return false;
        }

        public long getIndex() {
            throw new UnsupportedOperationException();
        }

        public String getKey() {
            throw new UnsupportedOperationException();
        }

        public Object getKeyOrIndex() {
            if (this.isIndex()) {
                return this.getIndex();
            }
            return this.getKey();
        }

        public abstract NodeId fallbackId();

        static {
            for (int i = 0; i < INDEXES.length; ++i) {
                NodeId.INDEXES[i] = new IndexId(i);
            }
        }
    }
}

