/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.path;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.IdentityHashMap;
import java.util.Map;
import org.javersion.path.PropertyPath;
import org.javersion.path.SchemaBase;
import org.javersion.util.Check;

public class Schema<T>
extends SchemaBase<Schema<T>> {
    private final T value;
    private final Map<PropertyPath.NodeId, Schema<T>> children;

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    protected Schema(Builder<T> builder) {
        this(builder, new IdentityHashMap<Builder<T>, Schema<T>>());
    }

    private Schema(Builder<T> schemaBuilder, IdentityHashMap<Builder<T>, Schema<T>> schemas) {
        schemas.put(schemaBuilder, this);
        ImmutableMap.Builder children = ImmutableMap.builder();
        for (Map.Entry entry : ((Builder)schemaBuilder).children.entrySet()) {
            Builder childBuilder = (Builder)entry.getValue();
            Schema<T> child = schemas.get(childBuilder);
            if (child == null) {
                child = new Schema<T>(childBuilder, schemas);
            }
            children.put(entry.getKey(), child);
        }
        this.value = ((Builder)schemaBuilder).value;
        this.children = children.build();
    }

    public T getValue() {
        return this.value;
    }

    @Override
    public Schema<T> getChild(PropertyPath.NodeId nodeId) {
        Check.notNull((Object)nodeId, (String)"nodeId");
        return this.children.get(nodeId);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public boolean hasChild(PropertyPath.NodeId nodeId) {
        return this.children.containsKey(nodeId);
    }

    public static class Builder<T>
    extends SchemaBase<Builder<T>> {
        private T value;
        private Map<PropertyPath.NodeId, Builder<T>> children = Maps.newHashMap();

        public Builder() {
        }

        public Builder(T value) {
            this.value = value;
        }

        @Override
        public Builder<T> getChild(PropertyPath.NodeId nodeId) {
            Check.notNull((Object)nodeId, (String)"nodeId");
            return this.children.get(nodeId);
        }

        public Builder<T> addChild(PropertyPath.NodeId nodeId, Builder<T> child) {
            this.children.put(nodeId, child);
            return child;
        }

        public T getValue() {
            return this.value;
        }

        public Builder<T> setValue(T value) {
            this.value = value;
            return this;
        }

        public Schema<T> build() {
            return new Schema(this);
        }

        public Builder<T> connect(PropertyPath.SubPath subPath, Builder<T> schema) {
            Builder<T> parent = this.getOrCreate(subPath.parent);
            parent.addChild(subPath.getNodeId(), schema);
            return this;
        }

        public Builder<T> getOrCreate(PropertyPath path) {
            return this.getOrCreate(path, null);
        }

        public Builder<T> getOrCreate(PropertyPath path, T value) {
            Builder<T> schema = this;
            for (PropertyPath propertyPath : path.asList()) {
                PropertyPath.NodeId nodeId = propertyPath.getNodeId();
                Builder<T> child = schema.getChild(nodeId);
                if (child == null) {
                    child = new Builder<T>();
                    schema.addChild(nodeId, child);
                }
                schema = child;
            }
            if (value != null) {
                return schema.setValue(value);
            }
            return schema;
        }
    }
}

