/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.path;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.javersion.path.PropertyPath;

public class PropertyTree {
    public final PropertyPath path;
    private Map<PropertyPath.NodeId, PropertyTree> children = Maps.newLinkedHashMap();

    public static PropertyTree build(PropertyPath ... paths) {
        return PropertyTree.build(Arrays.asList(paths));
    }

    public static PropertyTree build(Collection<PropertyPath> paths) {
        HashMap nodes = Maps.newHashMapWithExpectedSize((int)paths.size());
        for (PropertyPath path : paths) {
            PropertyTree parentTree = PropertyTree.getOrCreate(PropertyPath.ROOT, nodes);
            for (PropertyPath subPath : path) {
                PropertyTree childTree = PropertyTree.getOrCreate(subPath, nodes);
                if (parentTree != null) {
                    parentTree.children.put(subPath.getNodeId(), childTree);
                }
                parentTree = childTree;
            }
        }
        return (PropertyTree)nodes.get(PropertyPath.ROOT);
    }

    private static PropertyTree getOrCreate(PropertyPath path, Map<PropertyPath, PropertyTree> nodes) {
        PropertyTree childTree = nodes.get(path);
        if (childTree == null) {
            childTree = new PropertyTree(path);
            nodes.put(path, childTree);
        }
        return childTree;
    }

    private PropertyTree(PropertyPath path) {
        this.path = path;
    }

    public PropertyPath.NodeId getNodeId() {
        return this.path.getNodeId();
    }

    public Collection<PropertyTree> getChildren() {
        return Collections.unmodifiableCollection(this.children.values());
    }

    public Map<PropertyPath.NodeId, PropertyTree> getChildrenMap() {
        return Collections.unmodifiableMap(this.children);
    }

    public PropertyTree get(PropertyPath.NodeId childNode) {
        return this.children.get(childNode);
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public PropertyTree get(PropertyPath path) {
        PropertyTree match = this;
        for (PropertyPath node : path) {
            if (match == null) break;
            match = match.get(node.getNodeId());
        }
        if (match == null) {
            throw new IllegalArgumentException("path not found: " + path);
        }
        return match;
    }

    public String toString() {
        return this.path.toString();
    }
}

