/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.path;

import org.javersion.util.Check;

public abstract class NodeId
implements Comparable<NodeId> {
    public static final NodeId ROOT_ID = new SpecialNodeId("", null);
    public static final NodeId ANY = new SpecialNodeId("*", null);
    public static final NodeId ANY_INDEX = new SpecialNodeId("[]", ANY);
    public static final NodeId ANY_KEY = new SpecialNodeId("{}", ANY);
    public static final NodeId ANY_PROPERTY = new SpecialNodeId(".*", ANY_KEY);
    private static final IndexId[] INDEXES = new IndexId[32];

    public static IndexId valueOf(long index) {
        if (index >= 0L && index < (long)INDEXES.length) {
            return INDEXES[(int)index];
        }
        return new IndexId(index);
    }

    public static KeyId valueOf(String key) {
        return new KeyId(key);
    }

    public static NodeId valueOf(Object object) {
        if (object instanceof Number) {
            return NodeId.valueOf(((Number)object).longValue());
        }
        if (object instanceof String) {
            return NodeId.valueOf((String)object);
        }
        throw new IllegalArgumentException("Unsupported NodeId type: " + object);
    }

    NodeId() {
    }

    public boolean isIndex() {
        return false;
    }

    public boolean isKey() {
        return false;
    }

    public long getIndex() {
        throw new UnsupportedOperationException();
    }

    public String getKey() {
        throw new UnsupportedOperationException();
    }

    public Object getKeyOrIndex() {
        if (this.isIndex()) {
            return this.getIndex();
        }
        return this.getKey();
    }

    public abstract NodeId fallbackId();

    protected abstract int getTypeOrdinal();

    static {
        for (int i = 0; i < INDEXES.length; ++i) {
            NodeId.INDEXES[i] = new IndexId(i);
        }
    }

    static final class SpecialNodeId
    extends NodeId {
        private final String str;
        private final NodeId fallback;

        private SpecialNodeId(String str, NodeId fallback) {
            this.str = str;
            this.fallback = fallback;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof SpecialNodeId && ((SpecialNodeId)obj).str.equals(this.str);
        }

        public int hashCode() {
            return this.str.hashCode();
        }

        public String toString() {
            return this.str;
        }

        @Override
        public NodeId fallbackId() {
            return this.fallback;
        }

        @Override
        protected int getTypeOrdinal() {
            return 1;
        }

        @Override
        public int compareTo(NodeId nodeId) {
            return nodeId instanceof SpecialNodeId ? this.str.compareTo(((SpecialNodeId)nodeId).str) : Integer.compare(this.getTypeOrdinal(), nodeId.getTypeOrdinal());
        }
    }

    public static final class PropertyId
    extends KeyId {
        PropertyId(String key) {
            super(key);
        }

        @Override
        public NodeId fallbackId() {
            return ANY_PROPERTY;
        }
    }

    public static class KeyId
    extends NodeId {
        public final String key;

        KeyId(String key) {
            Check.notNull((Object)key, (String)"key");
            this.key = key;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            return obj instanceof KeyId && ((KeyId)obj).key.equals(this.key);
        }

        @Override
        public boolean isKey() {
            return true;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public String toString() {
            return this.key;
        }

        @Override
        public NodeId fallbackId() {
            return ANY_KEY;
        }

        @Override
        protected int getTypeOrdinal() {
            return 3;
        }

        @Override
        public int compareTo(NodeId nodeId) {
            return nodeId instanceof KeyId ? this.key.compareTo(((KeyId)nodeId).key) : Integer.compare(this.getTypeOrdinal(), nodeId.getTypeOrdinal());
        }
    }

    public static final class IndexId
    extends NodeId {
        public final long index;

        IndexId(long index) {
            this.index = index;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof IndexId) {
                return ((IndexId)obj).index == this.index;
            }
            return false;
        }

        @Override
        public boolean isIndex() {
            return true;
        }

        @Override
        public long getIndex() {
            return this.index;
        }

        public int hashCode() {
            return Long.hashCode(this.index);
        }

        public String toString() {
            return Long.toString(this.index);
        }

        @Override
        public NodeId fallbackId() {
            return ANY_INDEX;
        }

        @Override
        protected int getTypeOrdinal() {
            return 2;
        }

        @Override
        public int compareTo(NodeId nodeId) {
            return nodeId instanceof IndexId ? Long.compare(this.index, ((IndexId)nodeId).index) : Integer.compare(this.getTypeOrdinal(), nodeId.getTypeOrdinal());
        }
    }
}

