/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.javersion.reflect.AbstractTypeDescriptor;
import org.javersion.reflect.AbstractTypeDescriptors;
import org.javersion.reflect.ElementDescriptor;
import org.javersion.reflect.ReflectionException;
import org.javersion.util.Check;

public abstract class AbstractFieldDescriptor<F extends AbstractFieldDescriptor<F, T, Ts>, T extends AbstractTypeDescriptor<F, T, Ts>, Ts extends AbstractTypeDescriptors<F, T, Ts>>
extends ElementDescriptor<F, T, Ts> {
    protected final Field field;

    public AbstractFieldDescriptor(Ts typeDescriptors, Field field) {
        super(typeDescriptors);
        this.field = (Field)Check.notNull((Object)field, (String)"field");
        field.setAccessible(true);
    }

    public Object getStatic() {
        return this.get(null);
    }

    public Object get(Object obj) {
        try {
            return this.field.get(obj);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }

    public void setStatic(Object value) {
        this.set(null, value);
    }

    public void set(Object obj, Object value) {
        try {
            this.field.set(obj, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.field.getModifiers());
    }

    public T getType() {
        return this.typeDescriptors.get(this.field.getGenericType());
    }

    @Override
    public Field getElement() {
        return this.field;
    }

    @Override
    public final int hashCode() {
        return 31 * this.typeDescriptors.hashCode() + this.field.hashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractFieldDescriptor) {
            AbstractFieldDescriptor other = (AbstractFieldDescriptor)obj;
            return this.typeDescriptors.equals(other.typeDescriptors) && this.field.equals(other.field);
        }
        return false;
    }

    public String getName() {
        return this.field.getName();
    }

    public String toString() {
        return this.field.getDeclaringClass().getCanonicalName() + "." + this.getName();
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.field.getModifiers());
    }
}

