/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.reflect;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.javersion.reflect.AbstractFieldDescriptor;
import org.javersion.reflect.AbstractTypeDescriptors;
import org.javersion.reflect.ElementDescriptor;
import org.javersion.reflect.ReflectionException;
import org.javersion.util.Check;

public abstract class AbstractTypeDescriptor<F extends AbstractFieldDescriptor<F, T, Ts>, T extends AbstractTypeDescriptor<F, T, Ts>, Ts extends AbstractTypeDescriptors<F, T, Ts>>
extends ElementDescriptor<F, T, Ts> {
    public static final BiMap<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE;
    private static final Predicate<Class<?>> isInterface;
    protected final TypeToken<?> typeToken;
    private volatile SortedMap<String, F> fields;
    private volatile Set<Class<?>> classes;

    public AbstractTypeDescriptor(Ts typeDescriptors, TypeToken<?> typeToken) {
        super(typeDescriptors);
        this.typeToken = (TypeToken)Check.notNull(typeToken, (String)"typeToken");
    }

    public boolean equalTo(Class<?> type) {
        return this.getRawType().equals(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, F> getFields() {
        Object result = this.fields;
        if (result == null) {
            AbstractTypeDescriptor abstractTypeDescriptor = this;
            synchronized (abstractTypeDescriptor) {
                result = this.fields;
                if (result == null) {
                    result = Maps.newHashMap();
                    this.collectFields(this.typeToken.getRawType(), (Map<String, F>)result);
                    result = this.fields = ImmutableSortedMap.copyOf(result);
                }
            }
        }
        return result;
    }

    public Set<Class<?>> getSuperClasses() {
        return Sets.filter(this.getAllClasses(), (Predicate)Predicates.not(isInterface));
    }

    public Set<Class<?>> getInterfaces() {
        return Sets.filter(this.getAllClasses(), isInterface);
    }

    public Set<Class<?>> getAllClasses() {
        if (this.classes == null) {
            this.classes = Collections.unmodifiableSet(AbstractTypeDescriptor.collectAllClasses(this.getRawType(), AbstractTypeDescriptor.newLinkedHashSet()));
        }
        return this.classes;
    }

    public String getSimpleName() {
        String fqn = this.getRawType().getName();
        int i = fqn.lastIndexOf(46);
        if (i > 0) {
            return fqn.substring(i + 1);
        }
        return fqn;
    }

    public boolean hasField(String fieldName) {
        return this.getFields().containsKey(fieldName);
    }

    public F getField(String name) {
        AbstractFieldDescriptor field = (AbstractFieldDescriptor)this.getFields().get(name);
        if (field == null) {
            throw new IllegalArgumentException("Field not found: " + name);
        }
        return (F)field;
    }

    public T resolveGenericParameter(Class<?> genericClass, int genericParam) {
        return this.typeDescriptors.get(this.typeToken.resolveType(genericClass.getTypeParameters()[genericParam]));
    }

    @Override
    public Class<?> getElement() {
        return this.getRawType();
    }

    public Class<?> getRawType() {
        return this.typeToken.getRawType();
    }

    private void collectFields(Class<?> clazz, Map<String, F> fields) {
        for (Field field : clazz.getDeclaredFields()) {
            if (!this.typeDescriptors.fieldFilter.apply((Object)field) || fields.containsKey(field.getName())) continue;
            fields.put(field.getName(), this.typeDescriptors.newFieldDescriptor(field));
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            this.collectFields(superClass, fields);
        }
    }

    private static Set<Class<?>> collectAllClasses(Class<?> clazz, LinkedHashSet<Class<?>> classes) {
        classes.add(clazz);
        ArrayList stack = Lists.newArrayList();
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null) {
            classes.add(superClass);
            stack.add(superClass);
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            if (!classes.add(iface)) continue;
            stack.add(iface);
        }
        for (Class next : stack) {
            AbstractTypeDescriptor.collectAllClasses(next, classes);
        }
        return classes;
    }

    public boolean isPrimitiveOrWrapper() {
        Class<?> clazz = this.getRawType();
        return WRAPPER_TO_PRIMITIVE.containsKey(clazz) || WRAPPER_TO_PRIMITIVE.containsValue(clazz);
    }

    public boolean isSuperTypeOf(Class<?> clazz) {
        return this.getRawType().isAssignableFrom(clazz);
    }

    public boolean isSubTypeOf(Class<?> clazz) {
        return clazz.isAssignableFrom(this.getRawType());
    }

    public boolean isEnum() {
        return this.getRawType().isEnum();
    }

    public Object newInstance() {
        try {
            Constructor<?> constructor = this.getRawType().getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ReflectionException("Failed to instantiate " + this.toString(), e);
        }
    }

    private static LinkedHashSet<Class<?>> newLinkedHashSet() {
        return Sets.newLinkedHashSet();
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractTypeDescriptor) {
            AbstractTypeDescriptor other = (AbstractTypeDescriptor)obj;
            return this.getTypeDescriptors().equals(other.getTypeDescriptors()) && this.typeToken.equals(other.typeToken);
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return 31 * this.typeDescriptors.hashCode() + this.typeToken.hashCode();
    }

    public String toString() {
        return this.typeToken.toString();
    }

    static {
        ImmutableBiMap.Builder primitives = ImmutableBiMap.builder();
        primitives.put(Byte.class, Byte.TYPE);
        primitives.put(Short.class, Short.TYPE);
        primitives.put(Integer.class, Integer.TYPE);
        primitives.put(Long.class, Long.TYPE);
        primitives.put(Float.class, Float.TYPE);
        primitives.put(Double.class, Double.TYPE);
        primitives.put(Boolean.class, Boolean.TYPE);
        primitives.put(Character.class, Character.TYPE);
        primitives.put(Void.TYPE, Void.TYPE);
        WRAPPER_TO_PRIMITIVE = primitives.build();
        isInterface = input -> input.isInterface();
    }
}

