/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.reflect;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.javersion.reflect.MemberDescriptor;
import org.javersion.reflect.ParameterDescriptor;
import org.javersion.reflect.ReflectionException;
import org.javersion.reflect.TypeDescriptor;
import org.javersion.util.Check;

public final class MethodDescriptor
extends MemberDescriptor {
    @Nonnull
    private final Method method;

    public MethodDescriptor(TypeDescriptor declaringType, Method method) {
        super(declaringType);
        this.method = (Method)Check.notNull((Object)method, (String)"method");
        method.setAccessible(true);
    }

    public TypeDescriptor getReturnType() {
        return this.resolveType(this.method.getGenericReturnType());
    }

    public List<ParameterDescriptor> getParameters() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Parameter parameter : this.method.getParameters()) {
            builder.add((Object)new ParameterDescriptor(this.declaringType, parameter));
        }
        return builder.build();
    }

    public String getName() {
        return this.method.getName();
    }

    public Object invoke(Object object, Object ... args) {
        try {
            return this.method.invoke(object, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof MethodDescriptor) {
            MethodDescriptor other = (MethodDescriptor)obj;
            return this.declaringType.equals(other.declaringType) && this.method.equals(other.method);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31 * this.declaringType.hashCode() + this.method.hashCode();
    }

    public boolean applies(TypeDescriptor typeDescriptor) {
        return typeDescriptor.isSubTypeOf(this.method.getDeclaringClass());
    }

    public String toString() {
        return this.getDeclaringType().getSimpleName() + "." + this.getName() + this.getParameters().stream().map(ParameterDescriptor::getType).map(TypeDescriptor::getSimpleName).collect(Collectors.joining(",", "(", ")"));
    }

    @Override
    Method getElement() {
        return this.method;
    }
}

