/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.reflect;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.javersion.reflect.TypeDescriptor;

public final class ConstructorSignature {
    public static final ConstructorSignature DEFAULT_CONSTRUCTOR = new ConstructorSignature(new Class[0]);
    public static final ConstructorSignature STRING_CONSTRUCTOR = new ConstructorSignature(String.class);
    @Nonnull
    private final List<Class<?>> parameterTypes;

    public ConstructorSignature(Constructor<?> constructor) {
        this(constructor.getParameterTypes());
    }

    public ConstructorSignature(Class<?> ... parameterTypes) {
        this.parameterTypes = ImmutableList.copyOf((Object[])parameterTypes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstructorSignature that = (ConstructorSignature)o;
        return this.parameterTypes.equals(that.parameterTypes);
    }

    public int hashCode() {
        return this.parameterTypes.hashCode();
    }

    public String toString() {
        return this.parameterTypes.stream().map(TypeDescriptor::getSimpleName).collect(Collectors.joining(",", "(", ")"));
    }
}

