/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.reflect;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.javersion.reflect.TypeDescriptor;
import org.javersion.util.Check;

public final class MethodSignature {
    @Nonnull
    public final String name;
    @Nonnull
    public final List<Class<?>> parameterTypes;

    public MethodSignature(Method method) {
        this(method.getName(), method.getParameterTypes());
    }

    public MethodSignature(String name, Class<?> ... parameterTypes) {
        this(name, (List<Class<?>>)ImmutableList.copyOf((Object[])parameterTypes));
    }

    public MethodSignature(String name, List<Class<?>> parameterTypes) {
        this.name = Check.notNullOrEmpty((String)name, (String)"name");
        Check.notNull(parameterTypes, (String)"parameterTypes");
        this.parameterTypes = ImmutableList.copyOf(parameterTypes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodSignature)) {
            return false;
        }
        MethodSignature that = (MethodSignature)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.parameterTypes.equals(that.parameterTypes);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.parameterTypes.hashCode();
        return result;
    }

    public String toString() {
        return this.name + this.parameterTypes.stream().map(TypeDescriptor::getSimpleName).collect(Collectors.joining(",", "(", ")"));
    }
}

