/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.reflect;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nonnull;
import org.javersion.reflect.ElementDescriptor;
import org.javersion.reflect.TypeDescriptor;
import org.javersion.reflect.TypeDescriptors;
import org.javersion.util.Check;

public abstract class MemberDescriptor
implements ElementDescriptor {
    @Nonnull
    protected final TypeDescriptor declaringType;

    public MemberDescriptor(TypeDescriptor declaringType) {
        this.declaringType = (TypeDescriptor)Check.notNull((Object)declaringType, (String)"declaringType");
    }

    @Override
    public List<Annotation> getAnnotations() {
        return ImmutableList.copyOf((Object[])this.getElement().getAnnotations());
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        return this.getElement().getAnnotation(annotationClass);
    }

    @Override
    public <A extends Annotation> boolean hasAnnotation(Class<A> annotationClass) {
        return this.getElement().isAnnotationPresent(annotationClass);
    }

    public final TypeDescriptor getDeclaringType() {
        return this.declaringType;
    }

    TypeToken<?> getSourceType() {
        return this.declaringType.getTypeToken();
    }

    TypeDescriptor resolveType(Type genericType) {
        TypeToken resolveType = this.getSourceType().resolveType(genericType);
        return this.getTypeDescriptor(resolveType);
    }

    TypeDescriptor getTypeDescriptor(TypeToken typeToken) {
        return this.getTypeDescriptors().get(typeToken);
    }

    TypeDescriptors getTypeDescriptors() {
        return this.declaringType.getTypeDescriptors();
    }

    abstract AnnotatedElement getElement();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);
}

