/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.reflect;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import org.javersion.reflect.TypeDescriptor;
import org.javersion.util.Check;

public final class TypeDescriptors {
    public static final Predicate<Member> NON_SYNTHETIC = member -> !member.isSynthetic();
    public static final TypeDescriptors DEFAULT = new TypeDescriptors();
    private final Map<TypeToken<?>, TypeDescriptor> cache = Maps.newHashMap();
    protected final Predicate<? super Field> fieldFilter;
    protected final Predicate<? super Method> methodFilter;
    protected final Predicate<? super Constructor> constructorFilter;

    public static TypeDescriptor getTypeDescriptor(Class<?> clazz) {
        Check.notNull(clazz, (String)"clazz");
        return DEFAULT.get(clazz);
    }

    public TypeDescriptors() {
        this(NON_SYNTHETIC);
    }

    public TypeDescriptors(Predicate<? super Member> memberFilter) {
        this(memberFilter, memberFilter, memberFilter);
    }

    public TypeDescriptors(Predicate<? super Field> fieldFilter, Predicate<? super Method> methodFilter, Predicate<? super Constructor> constructorFilter) {
        this.fieldFilter = (Predicate)Check.notNull(fieldFilter, (String)"fieldFilter");
        this.methodFilter = (Predicate)Check.notNull(methodFilter, (String)"methodFilter");
        this.constructorFilter = (Predicate)Check.notNull(constructorFilter, (String)"constructorFilter");
    }

    public TypeDescriptor get(Class<?> clazz) {
        return this.get(TypeToken.of(clazz));
    }

    public TypeDescriptor get(Type type) {
        return this.get(TypeToken.of((Type)type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeDescriptor get(TypeToken<?> typeToken) {
        Map<TypeToken<?>, TypeDescriptor> map = this.cache;
        synchronized (map) {
            TypeDescriptor descriptor = this.cache.get(typeToken);
            if (descriptor == null) {
                descriptor = new TypeDescriptor(this, typeToken);
                this.cache.put(typeToken, descriptor);
            }
            return descriptor;
        }
    }
}

