/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.reflect;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.javersion.reflect.JavaMemberDescriptor;
import org.javersion.reflect.ParameterDescriptor;
import org.javersion.reflect.ReflectionException;
import org.javersion.reflect.StaticExecutable;
import org.javersion.reflect.TypeDescriptor;
import org.javersion.util.Check;

public final class ConstructorDescriptor
extends JavaMemberDescriptor<Constructor<?>>
implements StaticExecutable {
    @Nonnull
    private final Constructor<?> constructor;

    public ConstructorDescriptor(TypeDescriptor declaringType, Constructor<?> constructor) {
        super(declaringType);
        this.constructor = (Constructor)Check.notNull(constructor, (String)"method");
        constructor.setAccessible(true);
    }

    @Override
    public List<ParameterDescriptor> getParameters() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Parameter parameter : this.constructor.getParameters()) {
            builder.add((Object)new ParameterDescriptor(this.declaringType, parameter));
        }
        return builder.build();
    }

    @Override
    public Object invokeStatic(Object ... args) {
        return this.newInstance(args);
    }

    public Object newInstance(Object ... args) {
        try {
            return this.constructor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new ReflectionException(e);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ConstructorDescriptor) {
            ConstructorDescriptor other = (ConstructorDescriptor)obj;
            return this.declaringType.equals(other.declaringType) && this.constructor.equals(other.constructor);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31 * this.declaringType.hashCode() + Arrays.hashCode(this.constructor.getParameterTypes());
    }

    public boolean applies(TypeDescriptor typeDescriptor) {
        return typeDescriptor.equalTo(this.constructor.getDeclaringClass());
    }

    public String toString() {
        return this.getDeclaringType().getSimpleName() + this.getParameters().stream().map(ParameterDescriptor::getType).map(TypeDescriptor::getSimpleName).collect(Collectors.joining(",", "(", ")"));
    }

    @Override
    Constructor<?> getElement() {
        return this.constructor;
    }
}

