/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.reflect;

import org.javersion.reflect.AccessibleProperty;
import org.javersion.reflect.MethodDescriptor;
import org.javersion.reflect.TypeDescriptor;
import org.javersion.util.Check;

public class BeanProperty
implements AccessibleProperty {
    private final String name;
    private final MethodDescriptor readMethod;
    private final MethodDescriptor writeMethod;

    public BeanProperty(String name, MethodDescriptor readMethod, MethodDescriptor writeMethod) {
        this.name = (String)Check.notNull((Object)name, (String)"name");
        this.readMethod = readMethod;
        this.writeMethod = writeMethod;
        if (readMethod == null && writeMethod == null) {
            throw new IllegalArgumentException("Both readMethod and writeMethod cannot be null");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isReadable() {
        return this.readMethod != null;
    }

    @Override
    public boolean isWritable() {
        return this.writeMethod != null;
    }

    public MethodDescriptor getReadMethod() {
        return this.readMethod;
    }

    public MethodDescriptor getWriteMethod() {
        return this.writeMethod;
    }

    @Override
    public void set(Object bean, Object value) {
        this.writeMethod.invoke(bean, value);
    }

    @Override
    public Object get(Object bean) {
        return this.readMethod.invoke(bean, new Object[0]);
    }

    @Override
    public boolean isReadableFrom(TypeDescriptor typeDescriptor) {
        return this.readMethod != null && this.readMethod.applies(typeDescriptor);
    }

    @Override
    public boolean isWritableFrom(TypeDescriptor typeDescriptor) {
        return this.writeMethod != null && this.writeMethod.applies(typeDescriptor);
    }

    public TypeDescriptor getDeclaringType() {
        if (this.readMethod != null) {
            return this.readMethod.getDeclaringType();
        }
        return this.writeMethod.getDeclaringType();
    }

    @Override
    public TypeDescriptor getType() {
        if (this.readMethod != null) {
            return this.readMethod.getReturnType();
        }
        return this.writeMethod.getParameters().get(0).getType();
    }
}

