/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.annotation.Nonnull;
import org.javersion.reflect.AccessibleProperty;
import org.javersion.reflect.JavaMemberDescriptor;
import org.javersion.reflect.ReflectionException;
import org.javersion.reflect.TypeDescriptor;
import org.javersion.util.Check;

public final class FieldDescriptor
extends JavaMemberDescriptor<Field>
implements AccessibleProperty {
    @Nonnull
    private final Field field;

    public FieldDescriptor(TypeDescriptor typeDescriptor, Field field) {
        super(typeDescriptor);
        this.field = (Field)Check.notNull((Object)field, (String)"field");
        field.setAccessible(true);
    }

    public Object getStatic() {
        return this.get(null);
    }

    @Override
    public Object get(Object obj) {
        try {
            return this.field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new ReflectionException(e);
        }
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    @Override
    public boolean isReadableFrom(TypeDescriptor typeDescriptor) {
        return typeDescriptor.isSubTypeOf(this.field.getDeclaringClass());
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public boolean isWritableFrom(TypeDescriptor typeDescriptor) {
        return typeDescriptor.isSubTypeOf(this.field.getDeclaringClass());
    }

    public void setStatic(Object value) {
        this.set(null, value);
    }

    @Override
    public void set(Object obj, Object value) {
        try {
            this.field.set(obj, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ReflectionException(e);
        }
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.field.getModifiers());
    }

    @Override
    public TypeDescriptor getType() {
        return this.resolveType(this.field.getGenericType());
    }

    @Override
    public Field getElement() {
        return this.field;
    }

    @Override
    public final int hashCode() {
        return 31 * this.getDeclaringType().hashCode() + this.field.hashCode();
    }

    @Override
    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FieldDescriptor) {
            FieldDescriptor other = (FieldDescriptor)obj;
            return this.field.equals(other.field) && this.declaringType.equals(other.declaringType);
        }
        return false;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    public String toString() {
        return this.field.getDeclaringClass().getCanonicalName() + "." + this.getName();
    }
}

