/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.reflect;

import com.thoughtworks.paranamer.Paranamer;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Parameter;
import javax.annotation.Nonnull;
import org.javersion.reflect.AbstractMethodDescriptor;
import org.javersion.reflect.MemberDescriptor;
import org.javersion.reflect.Param;
import org.javersion.reflect.TypeDescriptor;
import org.javersion.util.Check;

public final class ParameterDescriptor
extends MemberDescriptor {
    @Nonnull
    private final AccessibleObject accessibleObject;
    @Nonnull
    private final Parameter parameter;
    private final int index;

    public ParameterDescriptor(AbstractMethodDescriptor methodDescriptor, Parameter parameter, int index) {
        super(methodDescriptor.getDeclaringType());
        this.accessibleObject = methodDescriptor.getElement();
        this.parameter = (Parameter)Check.notNull((Object)parameter, (String)"parameter");
        this.index = index;
    }

    @Override
    Parameter getElement() {
        return this.parameter;
    }

    public TypeDescriptor getType() {
        return this.resolveType(this.parameter.getParameterizedType());
    }

    public String getName() {
        Param param = this.getAnnotation(Param.class);
        if (param != null) {
            return param.value();
        }
        if (this.parameter.isNamePresent()) {
            return this.parameter.getName();
        }
        Paranamer paranamer = this.getTypeDescriptors().getParanamer();
        String[] names = paranamer.lookupParameterNames(this.accessibleObject);
        return names.length > this.index ? names[this.index] : null;
    }

    AccessibleObject getAccessibleObject() {
        return this.accessibleObject;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParameterDescriptor that = (ParameterDescriptor)o;
        if (!this.accessibleObject.equals(that.accessibleObject)) {
            return false;
        }
        return this.parameter.equals(that.parameter);
    }

    @Override
    public int hashCode() {
        int result = this.accessibleObject.hashCode();
        result = 31 * result + this.parameter.hashCode();
        return result;
    }
}

