/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.reflect;

import com.google.common.base.Predicate;
import com.google.common.reflect.TypeToken;
import com.thoughtworks.paranamer.BytecodeReadingParanamer;
import com.thoughtworks.paranamer.CachingParanamer;
import com.thoughtworks.paranamer.Paranamer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import org.javersion.reflect.TypeDescriptor;
import org.javersion.util.Check;

public final class TypeDescriptors {
    public static final Predicate<Member> NON_SYNTHETIC = member -> !member.isSynthetic();
    public static final TypeDescriptors DEFAULT = new TypeDescriptors();
    private final Map<TypeToken<?>, TypeDescriptor> cache = Collections.synchronizedMap(new WeakHashMap());
    protected final Predicate<? super Field> fieldFilter;
    protected final Predicate<? super Method> methodFilter;
    protected final Predicate<? super Constructor> constructorFilter;
    protected final Paranamer paranamer = new CachingParanamer((Paranamer)new BytecodeReadingParanamer());

    public static TypeDescriptor getTypeDescriptor(Class<?> clazz) {
        Check.notNull(clazz, (String)"clazz");
        return DEFAULT.get(clazz);
    }

    public TypeDescriptors() {
        this(NON_SYNTHETIC);
    }

    public TypeDescriptors(Predicate<? super Member> memberFilter) {
        this(memberFilter, memberFilter, memberFilter);
    }

    public TypeDescriptors(Predicate<? super Field> fieldFilter, Predicate<? super Method> methodFilter, Predicate<? super Constructor> constructorFilter) {
        this.fieldFilter = (Predicate)Check.notNull(fieldFilter, (String)"fieldFilter");
        this.methodFilter = (Predicate)Check.notNull(methodFilter, (String)"methodFilter");
        this.constructorFilter = (Predicate)Check.notNull(constructorFilter, (String)"constructorFilter");
    }

    public TypeDescriptor get(Class<?> clazz) {
        return this.get(TypeToken.of(clazz));
    }

    public TypeDescriptor get(Type type) {
        return this.get(TypeToken.of((Type)type));
    }

    public TypeDescriptor get(TypeToken<?> typeToken) {
        TypeDescriptor descriptor = this.cache.get(typeToken);
        if (descriptor == null) {
            descriptor = new TypeDescriptor(this, typeToken);
            this.cache.put(typeToken, descriptor);
        }
        return descriptor;
    }

    Paranamer getParanamer() {
        return this.paranamer;
    }
}

