/*
 * Decompiled with CFR 0.152.
 */
package org.javersion.reflect;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Map;
import org.javersion.reflect.AbstractFieldDescriptor;
import org.javersion.reflect.AbstractTypeDescriptor;
import org.javersion.util.Check;

public abstract class AbstractTypeDescriptors<F extends AbstractFieldDescriptor<F, T, Ts>, T extends AbstractTypeDescriptor<F, T, Ts>, Ts extends AbstractTypeDescriptors<F, T, Ts>> {
    public static final Predicate<Field> NON_STATIC_OR_SYNTETHIC_FIELD = field -> {
        int mod = field.getModifiers();
        return !Modifier.isStatic(mod) && !field.isSynthetic();
    };
    public final Function<Class<?>, T> getTypeDescriptor = input -> this.get((Class<?>)input);
    private final Map<TypeToken<?>, T> cache = Maps.newHashMap();
    protected final Predicate<? super Field> fieldFilter;

    public AbstractTypeDescriptors() {
        this(NON_STATIC_OR_SYNTETHIC_FIELD);
    }

    public AbstractTypeDescriptors(Predicate<? super Field> fieldFilter) {
        this.fieldFilter = (Predicate)Check.notNull(fieldFilter, (String)"fieldFilter");
    }

    public T get(Class<?> clazz) {
        return this.get(TypeToken.of(clazz));
    }

    public T get(Type type) {
        return this.get(TypeToken.of((Type)type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(TypeToken<?> typeToken) {
        Map<TypeToken<?>, T> map = this.cache;
        synchronized (map) {
            AbstractTypeDescriptor descriptor = (AbstractTypeDescriptor)this.cache.get(typeToken);
            if (descriptor == null) {
                descriptor = this.newTypeDescriptor(typeToken);
                this.cache.put(typeToken, descriptor);
            }
            return (T)descriptor;
        }
    }

    protected abstract F newFieldDescriptor(Field var1);

    protected abstract T newTypeDescriptor(TypeToken<?> var1);
}

