/*
 * Decompiled with CFR 0.152.
 */
package org.jaxxy.example.config;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.fasterxml.jackson.jaxrs.smile.JacksonSmileProvider;
import com.fasterxml.jackson.jaxrs.yaml.JacksonYAMLProvider;
import com.google.gson.Gson;
import java.util.List;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.jaxrs.openapi.OpenApiFeature;
import org.apache.cxf.jaxrs.swagger.Swagger2Feature;
import org.apache.cxf.transport.common.gzip.GZIPFeature;
import org.jaxxy.cors.CorsFilter;
import org.jaxxy.cors.ResourceSharingPolicy;
import org.jaxxy.example.cxf.JaxxyGzipFeature;
import org.jaxxy.example.service.DefaultHelloService;
import org.jaxxy.example.service.HelloService;
import org.jaxxy.gson.GsonMessageBodyProvider;
import org.jaxxy.jsonb.JsonbMessageBodyProvider;
import org.jaxxy.logging.LoggingContextDecorator;
import org.jaxxy.logging.LoggingContextFilter;
import org.jaxxy.logging.RequestLogFilter;
import org.jaxxy.logging.decorator.HeadersDecorator;
import org.jaxxy.logging.decorator.ResourceDecorator;
import org.jaxxy.protobuf.ProtobufMessageBodyProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JaxxyExampleConfiguration {
    @Bean
    @ConditionalOnProperty(name={"jaxxy.cors.enabled"}, matchIfMissing=true, havingValue="true")
    public CorsFilter corsFilter() {
        return new CorsFilter(ResourceSharingPolicy.defaultPolicy());
    }

    @Bean
    @ConditionalOnProperty(name={"jaxxy.gzipFeature.enabled"}, matchIfMissing=true, havingValue="true")
    public GZIPFeature gzipFeature() {
        return new JaxxyGzipFeature();
    }

    @Bean
    @ConditionalOnProperty(name={"jaxxy.loggingContext.headers.enabled"}, matchIfMissing=true, havingValue="true")
    public HeadersDecorator headersDecorator() {
        return new HeadersDecorator();
    }

    @Bean
    public ProtobufMessageBodyProvider protobufMessageBodyProvider() {
        return new ProtobufMessageBodyProvider();
    }

    @Bean
    public JacksonSmileProvider jacksonSmileProvider() {
        return new JacksonSmileProvider();
    }

    @Bean
    public JacksonYAMLProvider jacksonYAMLProvider() {
        return new JacksonYAMLProvider();
    }

    @Bean
    public HelloService helloService() {
        return new DefaultHelloService();
    }

    @Bean
    @ConditionalOnProperty(name={"jaxxy.json.provider"}, havingValue="jsonb")
    public JsonbMessageBodyProvider jsonbMessageBodyProvider() {
        return new JsonbMessageBodyProvider();
    }

    @Bean
    @ConditionalOnProperty(name={"jaxxy.json.provider"}, matchIfMissing=true, havingValue="gson")
    public GsonMessageBodyProvider gsonMessageBodyProvider(Gson gson) {
        return new GsonMessageBodyProvider(gson);
    }

    @Bean
    @ConditionalOnProperty(name={"jaxxy.json.provider"}, havingValue="jackson")
    public JacksonJsonProvider jacksonJsonProvider() {
        return new JacksonJsonProvider();
    }

    @Bean
    @ConditionalOnProperty(name={"jaxxy.loggingContext.enabled"}, matchIfMissing=true, havingValue="true")
    public LoggingContextFilter loggingContextFilter(List<LoggingContextDecorator> decorators) {
        return new LoggingContextFilter(decorators);
    }

    @Bean
    @ConditionalOnProperty(name={"jaxxy.loggingFeature.enabled"}, matchIfMissing=true, havingValue="true")
    public LoggingFeature loggingFeature() {
        return new LoggingFeature();
    }

    @Bean
    @ConditionalOnProperty(name={"jaxxy.requestLog.enabled"}, matchIfMissing=true, havingValue="true")
    public RequestLogFilter requestLogFilter() {
        return RequestLogFilter.builder().build();
    }

    @Bean
    @ConditionalOnProperty(name={"jaxxy.loggingContext.resource.enabled"}, matchIfMissing=true, havingValue="true")
    public ResourceDecorator resourceDecorator() {
        return new ResourceDecorator();
    }

    @Bean
    @ConditionalOnProperty(name={"jaxxy.swagger.enabled"}, matchIfMissing=true, havingValue="true")
    public Swagger2Feature swagger2Feature() {
        Swagger2Feature feature = new Swagger2Feature();
        feature.setScanAllResources(true);
        return feature;
    }

    @Bean
    @ConditionalOnProperty(name={"jaxxy.openapi.enabled"}, matchIfMissing=true, havingValue="true")
    public OpenApiFeature openApiFeature() {
        return new OpenApiFeature();
    }
}

