/*
 * Decompiled with CFR 0.152.
 */
package org.jaxxy.example.config;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import com.fasterxml.jackson.jaxrs.smile.JacksonSmileProvider;
import com.fasterxml.jackson.jaxrs.yaml.JacksonYAMLProvider;
import com.google.gson.Gson;
import org.apache.cxf.ext.logging.LoggingFeature;
import org.apache.cxf.jaxrs.openapi.OpenApiFeature;
import org.apache.cxf.jaxrs.swagger.Swagger2Feature;
import org.apache.cxf.transport.common.gzip.GZIPFeature;
import org.jaxxy.cors.CorsFilter;
import org.jaxxy.cors.ResourceSharingPolicy;
import org.jaxxy.example.service.DefaultHelloService;
import org.jaxxy.example.service.HelloService;
import org.jaxxy.gson.GsonMessageBodyProvider;
import org.jaxxy.jsonb.JsonbMessageBodyProvider;
import org.jaxxy.logging.RequestLogFilter;
import org.jaxxy.logging.mdc.DefaultRichMdc;
import org.jaxxy.logging.mdc.MdcCleanupFilter;
import org.jaxxy.logging.mdc.MdcHeadersFilter;
import org.jaxxy.logging.mdc.MdcResourceInfoFilter;
import org.jaxxy.logging.mdc.MdcUriInfoFilter;
import org.jaxxy.logging.mdc.MdcValueEncoder;
import org.jaxxy.logging.mdc.RichMdc;
import org.jaxxy.protobuf.ProtobufMessageBodyProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class JaxxyExampleConfiguration {
    @Bean
    @ConditionalOnProperty(name={"jaxxy.cors.enabled"}, matchIfMissing=true, havingValue="true")
    public CorsFilter corsFilter(ResourceSharingPolicy policy) {
        return new CorsFilter(policy);
    }

    @Bean
    @ConditionalOnProperty(name={"jaxxy.json.provider"}, matchIfMissing=true, havingValue="gson")
    public GsonMessageBodyProvider gsonMessageBodyProvider(Gson gson) {
        return new GsonMessageBodyProvider(gson);
    }

    @Bean
    @ConditionalOnProperty(name={"jaxxy.gzipFeature.enabled"}, matchIfMissing=true, havingValue="true")
    public GZIPFeature gzipFeature() {
        return new GZIPFeature();
    }

    @Bean
    public HelloService helloService() {
        return new DefaultHelloService();
    }

    @Bean
    @ConditionalOnProperty(name={"jaxxy.json.provider"}, havingValue="jackson")
    public JacksonJsonProvider jacksonJsonProvider() {
        return new JacksonJsonProvider();
    }

    @Bean
    public JacksonSmileProvider jacksonSmileProvider() {
        return new JacksonSmileProvider();
    }

    @Bean
    public JacksonYAMLProvider jacksonYAMLProvider() {
        return new JacksonYAMLProvider();
    }

    @Bean
    @ConditionalOnProperty(name={"jaxxy.json.provider"}, havingValue="jsonb")
    public JsonbMessageBodyProvider jsonbMessageBodyProvider() {
        return new JsonbMessageBodyProvider();
    }

    @Bean
    @ConditionalOnProperty(name={"jaxxy.loggingFeature.enabled"}, matchIfMissing=true, havingValue="true")
    public LoggingFeature loggingFeature() {
        return new LoggingFeature();
    }

    @Bean
    public MdcCleanupFilter mdcCleanupFilter() {
        return new MdcCleanupFilter();
    }

    @Bean
    @ConditionalOnProperty(name={"jaxxy.mdc.headers.enabled"}, matchIfMissing=true, havingValue="true")
    public MdcHeadersFilter mdcHeadersFilter(RichMdc mdc) {
        return new MdcHeadersFilter(mdc);
    }

    @Bean
    @ConditionalOnProperty(name={"jaxxy.mdc.resourceInfo.enabled"}, matchIfMissing=true, havingValue="true")
    public MdcResourceInfoFilter mdcResourceInfoFilter(RichMdc mdc) {
        return new MdcResourceInfoFilter(mdc);
    }

    @Bean
    @ConditionalOnProperty(name={"jaxxy.mdc.uriInfo.enabled"}, matchIfMissing=true, havingValue="true")
    public MdcUriInfoFilter mdcUriInfoFilter(RichMdc mdc) {
        return new MdcUriInfoFilter(mdc);
    }

    @Bean
    @ConditionalOnMissingBean
    public MdcValueEncoder mdcValueEncoder(Gson gson) {
        return arg_0 -> ((Gson)gson).toJson(arg_0);
    }

    @Bean
    @ConditionalOnProperty(name={"jaxxy.openapi.enabled"}, matchIfMissing=true, havingValue="true")
    public OpenApiFeature openApiFeature() {
        return new OpenApiFeature();
    }

    @Bean
    public ProtobufMessageBodyProvider protobufMessageBodyProvider() {
        return new ProtobufMessageBodyProvider();
    }

    @Bean
    @ConditionalOnProperty(name={"jaxxy.requestLog.enabled"}, matchIfMissing=true, havingValue="true")
    public RequestLogFilter requestLogFilter() {
        return RequestLogFilter.builder().build();
    }

    @Bean
    @ConditionalOnMissingBean
    public ResourceSharingPolicy resourceSharingPolicy() {
        return ResourceSharingPolicy.defaultPolicy();
    }

    @Bean
    public RichMdc richMdc(MdcValueEncoder encoder) {
        return new DefaultRichMdc(encoder);
    }

    @Bean
    @ConditionalOnProperty(name={"jaxxy.swagger.enabled"}, matchIfMissing=true, havingValue="true")
    public Swagger2Feature swagger2Feature() {
        Swagger2Feature feature = new Swagger2Feature();
        feature.setScanAllResources(true);
        return feature;
    }
}

