/*
 * Decompiled with CFR 0.152.
 */
package org.jaxxy.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jaxxy.io.MessageBodyProvider;

public abstract class CharacterMessageBodyProvider<T>
extends MessageBodyProvider<T> {
    protected abstract T readFrom(Class<T> var1, Type var2, Annotation[] var3, MediaType var4, MultivaluedMap<String, String> var5, Reader var6) throws IOException;

    protected abstract void writeTo(T var1, Class<?> var2, Type var3, Annotation[] var4, MediaType var5, MultivaluedMap<String, Object> var6, Writer var7) throws IOException;

    public final T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(entityStream, this.extractCharset(mediaType)));
        return this.readFrom(type, genericType, annotations, mediaType, httpHeaders, reader);
    }

    public final void writeTo(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        Charset charset = this.extractCharset(mediaType);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(entityStream, charset));
        this.writeTo(t, type, genericType, annotations, mediaType, httpHeaders, writer);
        ((Writer)writer).flush();
    }

    protected Charset defaultCharset() {
        return StandardCharsets.UTF_8;
    }

    private Charset extractCharset(MediaType mediaType) {
        return Charset.forName(mediaType.getParameters().getOrDefault("charset", this.defaultCharset().name()));
    }
}

