/*
 * Decompiled with CFR 0.152.
 */
package org.jaxxy.rx;

import jakarta.ws.rs.client.RxInvokerProvider;
import jakarta.ws.rs.client.SyncInvoker;
import jakarta.ws.rs.ext.Provider;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Function;
import lombok.Generated;
import org.jaxxy.rx.AbstractRxInvoker;
import org.jaxxy.rx.FutureInvoker;

@Provider
public class FutureInvokerProvider
implements RxInvokerProvider<FutureInvoker> {
    private final ExecutorService defaultExecutorService;

    public FutureInvokerProvider() {
        this(Executors.newCachedThreadPool());
    }

    public FutureInvokerProvider(ExecutorService defaultExecutorService) {
        this.defaultExecutorService = defaultExecutorService;
    }

    public FutureInvoker getRxInvoker(SyncInvoker syncInvoker, ExecutorService executorService) {
        return new Invoker(syncInvoker, Optional.ofNullable(executorService).orElse(this.defaultExecutorService));
    }

    public boolean isProviderFor(Class<?> clazz) {
        return FutureInvoker.class.equals(clazz);
    }

    private static class Invoker
    extends AbstractRxInvoker<Future>
    implements FutureInvoker {
        private final SyncInvoker syncInvoker;
        private final ExecutorService executorService;

        @Override
        protected <R> Future async(Function<SyncInvoker, R> fn) {
            return this.executorService.submit(() -> fn.apply(this.syncInvoker));
        }

        @Generated
        public Invoker(SyncInvoker syncInvoker, ExecutorService executorService) {
            this.syncInvoker = syncInvoker;
            this.executorService = executorService;
        }
    }
}

